/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.allocation.part;

import de.uka.ipd.sdq.pcm.gmf.allocation.part.PalladioComponentModelAllocationDiagramEditorPlugin;
import de.uka.ipd.sdq.pcm.gmf.allocation.part.PalladioComponentModelDiagramEditorUtil;
import de.uka.ipd.sdq.pcm.gmf.allocation.part.PcmNewAllocationDiagramFileWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class PalladioComponentModelInitDiagramFileAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private URI domainModelURI;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.domainModelURI = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        IFile file = (IFile)((IStructuredSelection)selection).getFirstElement();
        this.domainModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        action.setEnabled(true);
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        EObject diagramRoot = null;
        try {
            Resource resource = resourceSet.getResource(this.domainModelURI, true);
            diagramRoot = (EObject)resource.getContents().get(0);
        }
        catch (WrappedException ex) {
            PalladioComponentModelAllocationDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + this.domainModelURI, ex);
        }
        if (diagramRoot == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Model file loading failed");
            return;
        }
        PcmNewAllocationDiagramFileWizard wizard = new PcmNewAllocationDiagramFileWizard(this.domainModelURI, diagramRoot, editingDomain);
        wizard.setWindowTitle("Initialize new allocation diagram file");
        PalladioComponentModelDiagramEditorUtil.runWizard(this.getShell(), wizard, "InitDiagramFile");
    }
}

