/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean equalsIgnoreWhitespace(String left, String right) {
        String l = left == null ? "" : left.replaceAll("\\s", "");
        String r = right == null ? "" : right.replaceAll("\\s", "");
        return l.equals(r);
    }

    public static boolean equal(String literal, String name) {
        return Strings.isEmpty(name) ? Strings.isEmpty(literal) : literal.equals(name);
    }

    public static String notNull(Object o) {
        String string = String.valueOf(o);
        return string == null ? "null" : string;
    }

    public static String emptyIfNull(String s) {
        return s == null ? "" : s;
    }

    public static String concat(String separator, List<String> list) {
        return Strings.concat(separator, list, 0);
    }

    public static <T> String toString(Collection<T> list, Function<T, String> toString, String delim) {
        StringBuffer buffer = new StringBuffer();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            buffer.append((String)toString.apply(t));
            if (!iterator.hasNext()) continue;
            buffer.append(delim);
        }
        return buffer.toString();
    }

    public static String concat(String separator, List<String> list, int skip) {
        StringBuffer buff = new StringBuffer();
        int lastIndex = list.size() - skip;
        int i = 0;
        while (i < lastIndex) {
            buff.append(list.get(i));
            if (i + 1 < lastIndex) {
                buff.append(separator);
            }
            ++i;
        }
        String string = buff.toString();
        return string.trim().length() == 0 ? null : string;
    }

    public static String skipLastToken(String value, String separator) {
        int endIndex = value.lastIndexOf(separator);
        if (endIndex > 0) {
            return value.substring(0, endIndex);
        }
        return value;
    }

    public static String lastToken(String value, String separator) {
        int index = value.lastIndexOf(separator) + separator.length();
        if (index < value.length()) {
            return value.substring(index, value.length());
        }
        return "";
    }

    public static String toFirstUpper(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static String newLine() {
        return System.getProperty("line.separator");
    }

    public static String toFirstLower(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
    }

    public static String convertFromJavaString(String javaString) {
        char[] convtBuf;
        char[] in = javaString.toCharArray();
        int off = 0;
        int len = javaString.length();
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                } else if (aChar == 98) {
                    aChar = 8;
                } else if (aChar == 34) {
                    aChar = 34;
                } else if (aChar == 39) {
                    aChar = 39;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String convertToJavaString(String theString) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '\b': {
                        outBuffer.append('\\');
                        outBuffer.append('b');
                        break;
                    }
                    case '\'': {
                        outBuffer.append('\\');
                        outBuffer.append('\'');
                        break;
                    }
                    case '\"': {
                        outBuffer.append('\\');
                        outBuffer.append('\"');
                        break;
                    }
                    default: {
                        if (aChar < ' ' || aChar > '~') {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(Strings.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(Strings.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(Strings.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(Strings.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static List<String> split(String value, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int index = value.indexOf(delimiter, lastIndex);
        while (index != -1) {
            result.add(value.substring(lastIndex, index));
            lastIndex = index + delimiter.length();
            index = value.indexOf(delimiter, lastIndex);
        }
        result.add(value.substring(lastIndex));
        return result;
    }
}

