/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Files {
    private static Logger log = Logger.getLogger(Files.class);

    public static void copyFiles(String sourceDir, String targetDir, List<String> files) {
        File target = new File(targetDir);
        if (!target.exists()) {
            target.mkdir();
        }
        for (String file : files) {
            File copy = new File(String.valueOf(target.getAbsolutePath()) + File.separatorChar + file);
            if (copy.exists()) continue;
            String uri = String.valueOf(sourceDir) + "/" + file;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            InputStream is = contextClassLoader.getResourceAsStream(uri);
            try {
                try {
                    int read;
                    copy.createNewFile();
                    FileOutputStream fwr = new FileOutputStream(copy);
                    byte[] buff = new byte[1024];
                    while ((read = is.read(buff)) != -1) {
                        fwr.write(buff, 0, read);
                    }
                    log.debug((Object)("Copied " + copy));
                }
                catch (IOException e) {
                    log.error((Object)e);
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    public static boolean cleanFolder(File parentFolder, FileFilter filter, boolean continueOnError, boolean deleteParentFolder) throws FileNotFoundException {
        if (!parentFolder.exists()) {
            throw new FileNotFoundException(parentFolder.getAbsolutePath());
        }
        FileFilter myFilter = filter;
        if (myFilter == null) {
            myFilter = new FileFilter(){

                public boolean accept(File pathname) {
                    return true;
                }
            };
        }
        log.debug((Object)("Cleaning folder " + parentFolder.toString()));
        File[] contents = parentFolder.listFiles(myFilter);
        int j = 0;
        while (j < contents.length) {
            File file = contents[j];
            if (file.isDirectory()) {
                if (!Files.cleanFolder(file, myFilter, continueOnError, false) && !continueOnError) {
                    return false;
                }
            } else if (!file.delete()) {
                log.error((Object)("Couldn't delete " + file.getAbsolutePath()));
                if (!continueOnError) {
                    return false;
                }
            }
            ++j;
        }
        if (deleteParentFolder && !parentFolder.delete()) {
            log.error((Object)("Couldn't delete " + parentFolder.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public static boolean sweepFolder(File folder) throws FileNotFoundException {
        return Files.cleanFolder(folder, new FileFilter(){

            public boolean accept(File pathname) {
                return true;
            }
        }, true, false);
    }
}

