/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.text.scoping;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditor;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.index.IQualifiedNameProvider;
import org.eclipse.xtext.linking.impl.SimpleAttributeResolver;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopedElement;
import org.eclipse.xtext.scoping.impl.AbstractScopeProvider;
import org.eclipse.xtext.scoping.impl.ScopedElement;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class EdificeScopeProvider
extends AbstractScopeProvider {
    SimpleAttributeResolver<EObject, String> nameResolver = SimpleAttributeResolver.newResolver(String.class, (String)"name");
    @Inject
    private IQualifiedNameProvider nameProvider;

    public void setNameProvider(IQualifiedNameProvider nameProvider) {
        this.nameProvider = nameProvider;
    }

    public IScope getScope(EObject context, EReference reference) {
        if (reference != null) {
            return this.getScope(context, reference.getEReferenceType());
        }
        return IScope.NULLSCOPE;
    }

    protected IScope getGlobalScope(EObject context, EClass type) {
        IScope parent = IScope.NULLSCOPE;
        if (context.eResource() == null || context.eResource().getResourceSet() == null) {
            return parent;
        }
        try {
            IProject project = QImpressCore.getProject((URI)context.eResource().getURI());
            IQProject qProject = QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
            IQAlternative qAlternative = qProject.getRepository().getDefaultAlternative();
            ShadowModelEditor shadowModelEditor = (ShadowModelEditor)qAlternative.getAdapter(ShadowModelEditor.class);
            ResourceSet qImpressResourceSet = shadowModelEditor.getEditingDomain().getResourceSet();
            parent = this.createScopeWithQualifiedNames(parent, type, this.allEObjects(qImpressResourceSet));
        }
        catch (RepositoryException repositoryException) {}
        return parent;
    }

    private Iterable<EObject> allEObjects(final ResourceSet resourceSet) {
        Iterable<EObject> contents = new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                return EcoreUtil.getAllProperContents((ResourceSet)resourceSet, (boolean)true);
            }
        };
        Iterable filtered = Iterables.filter((Iterable)contents, EObject.class);
        return filtered;
    }

    protected IScope createScopeWithQualifiedNames(IScope parent, EClass type, Iterable<EObject> eObjects) {
        eObjects = Iterables.filter(eObjects, this.typeFilter(type));
        Iterable result = Iterables.transform((Iterable)eObjects, (Function)new Function<EObject, IScopedElement>(){

            public IScopedElement apply(EObject from) {
                String qualifiedName = EdificeScopeProvider.this.nameProvider.getQualifiedName(from);
                if (qualifiedName != null) {
                    return ScopedElement.create((String)qualifiedName, (EObject)from);
                }
                return null;
            }
        });
        return new SimpleScope(parent, Iterables.filter((Iterable)result, (Predicate)Predicates.notNull()));
    }

    protected Predicate<EObject> typeFilter(final EClass type) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return type.isInstance((Object)input);
            }
        };
    }

    protected Iterable<IScopedElement> getLocalElements(final EObject context, EClass type) {
        final String commonPrefix = String.valueOf(this.nameProvider.getQualifiedName(context)) + this.nameProvider.getDelimiter();
        Iterable<Object> contents = new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                TreeIterator ti = EcoreUtil.getAllProperContents((EObject)context, (boolean)true);
                return ti;
            }
        };
        contents = Iterables.filter((Iterable)contents, this.typeFilter(type));
        Iterable scopedElements = Iterables.transform((Iterable)contents, (Function)new Function<EObject, IScopedElement>(){

            public IScopedElement apply(EObject from) {
                String name = EdificeScopeProvider.this.nameProvider.getQualifiedName(from);
                if (name != null && name.startsWith(commonPrefix)) {
                    return ScopedElement.create((String)name.substring(commonPrefix.length()), (EObject)from);
                }
                return null;
            }
        });
        return Iterables.filter((Iterable)scopedElements, (Predicate)Predicates.notNull());
    }

    public IScope getScope(EObject context, EClass type) {
        IScope result = null;
        if (context != null) {
            result = context.eContainer() == null ? this.getGlobalScope(context, type) : this.getScope(context.eContainer(), type);
        }
        if (context.eContainer() != null && this.nameProvider.getQualifiedName(context) != null) {
            Iterable<IScopedElement> localElements = this.getLocalElements(context, type);
            result = new SimpleScope(result, localElements);
        }
        return result;
    }
}

