/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parseTreeConstructor;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.parseTreeConstructor.ParseTreeConstructorUtil;
import org.eclipse.xtext.parsetree.reconstr.IParseTreeConstructor;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstNFAToDot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTreeConstructorFragment
extends AbstractGeneratorFragment {
    protected static final Logger log = Logger.getLogger(ParseTreeConstructorFragment.class);
    private boolean generateDotDiagram = false;
    private String graphvizCommand = null;

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        super.generate(grammar, ctx);
        if (this.generateDotDiagram || this.graphvizCommand != null) {
            try {
                TreeConstNFAToDot ftd = new TreeConstNFAToDot();
                String fn = new File(String.valueOf(ctx.getOutput().getOutlet("SRC_GEN").getPath()) + "/" + Naming.asPath(ParseTreeConstructorUtil.getParseTreeConstructorName(grammar))).getCanonicalPath();
                if (this.generateDotDiagram) {
                    PrintStream out = new PrintStream(String.valueOf(fn) + ".dot");
                    ftd.draw((Object)grammar, out);
                    out.close();
                }
                if (this.graphvizCommand != null) {
                    String cmd = this.graphvizCommand.replace("%1", fn);
                    ftd.draw((Object)grammar, cmd);
                }
            }
            catch (IOException e) {
                log.error((Object)"IOError", (Throwable)e);
            }
        }
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        return new String[]{ParseTreeConstructorUtil.getPackage(grammar)};
    }

    @Override
    public Set<Binding> getGuiceBindingsRt(Grammar grammar) {
        return new BindFactory().addTypeToType(IParseTreeConstructor.class.getName(), ParseTreeConstructorUtil.getParseTreeConstructorName(grammar)).getBindings();
    }

    public void setGenerateDotDiagram(boolean enable) {
        this.generateDotDiagram = enable;
    }

    public void setGraphvizCommand(String cmd) {
        if (cmd != null && cmd.length() == 0) {
            cmd = null;
        }
        this.graphvizCommand = cmd;
    }
}

