/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.grammarAccess;

import java.net.URL;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnicodeCharacterDatabaseNames {
    public static void main(String[] args) {
        Pattern hexline = Pattern.compile("([0-9A-F]{4,5})\\s+(.*)");
        Pattern ident = Pattern.compile("[A-Z \\-_]+");
        try {
            Scanner s = new Scanner(new URL("http://www.unicode.org/Public/UNIDATA/NamesList.txt").openStream());
            while (s.hasNextLine()) {
                String line = s.nextLine();
                Matcher m = hexline.matcher(line);
                if (!m.matches()) continue;
                int cchar = Integer.parseInt(m.group(1), 16);
                if (cchar < 256) {
                    String cname = m.group(2);
                    if (!ident.matcher(cname).matches()) continue;
                    System.out.println("case " + cchar + ": return \"" + cname + "\"; // " + (char)cchar);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getCharacterName(char character) {
        switch (character) {
            case ' ': {
                return "SPACE";
            }
            case '!': {
                return "EXCLAMATION MARK";
            }
            case '\"': {
                return "QUOTATION MARK";
            }
            case '#': {
                return "NUMBER SIGN";
            }
            case '$': {
                return "DOLLAR SIGN";
            }
            case '%': {
                return "PERCENT SIGN";
            }
            case '&': {
                return "AMPERSAND";
            }
            case '\'': {
                return "APOSTROPHE";
            }
            case '(': {
                return "LEFT PARENTHESIS";
            }
            case ')': {
                return "RIGHT PARENTHESIS";
            }
            case '*': {
                return "ASTERISK";
            }
            case '+': {
                return "PLUS SIGN";
            }
            case ',': {
                return "COMMA";
            }
            case '-': {
                return "HYPHEN-MINUS";
            }
            case '.': {
                return "FULL STOP";
            }
            case '/': {
                return "SOLIDUS";
            }
            case '0': {
                return "DIGIT ZERO";
            }
            case '1': {
                return "DIGIT ONE";
            }
            case '2': {
                return "DIGIT TWO";
            }
            case '3': {
                return "DIGIT THREE";
            }
            case '4': {
                return "DIGIT FOUR";
            }
            case '5': {
                return "DIGIT FIVE";
            }
            case '6': {
                return "DIGIT SIX";
            }
            case '7': {
                return "DIGIT SEVEN";
            }
            case '8': {
                return "DIGIT EIGHT";
            }
            case '9': {
                return "DIGIT NINE";
            }
            case ':': {
                return "COLON";
            }
            case ';': {
                return "SEMICOLON";
            }
            case '<': {
                return "LESS-THAN SIGN";
            }
            case '=': {
                return "EQUALS SIGN";
            }
            case '>': {
                return "GREATER-THAN SIGN";
            }
            case '?': {
                return "QUESTION MARK";
            }
            case '@': {
                return "COMMERCIAL AT";
            }
            case 'A': {
                return "LATIN CAPITAL LETTER A";
            }
            case 'B': {
                return "LATIN CAPITAL LETTER B";
            }
            case 'C': {
                return "LATIN CAPITAL LETTER C";
            }
            case 'D': {
                return "LATIN CAPITAL LETTER D";
            }
            case 'E': {
                return "LATIN CAPITAL LETTER E";
            }
            case 'F': {
                return "LATIN CAPITAL LETTER F";
            }
            case 'G': {
                return "LATIN CAPITAL LETTER G";
            }
            case 'H': {
                return "LATIN CAPITAL LETTER H";
            }
            case 'I': {
                return "LATIN CAPITAL LETTER I";
            }
            case 'J': {
                return "LATIN CAPITAL LETTER J";
            }
            case 'K': {
                return "LATIN CAPITAL LETTER K";
            }
            case 'L': {
                return "LATIN CAPITAL LETTER L";
            }
            case 'M': {
                return "LATIN CAPITAL LETTER M";
            }
            case 'N': {
                return "LATIN CAPITAL LETTER N";
            }
            case 'O': {
                return "LATIN CAPITAL LETTER O";
            }
            case 'P': {
                return "LATIN CAPITAL LETTER P";
            }
            case 'Q': {
                return "LATIN CAPITAL LETTER Q";
            }
            case 'R': {
                return "LATIN CAPITAL LETTER R";
            }
            case 'S': {
                return "LATIN CAPITAL LETTER S";
            }
            case 'T': {
                return "LATIN CAPITAL LETTER T";
            }
            case 'U': {
                return "LATIN CAPITAL LETTER U";
            }
            case 'V': {
                return "LATIN CAPITAL LETTER V";
            }
            case 'W': {
                return "LATIN CAPITAL LETTER W";
            }
            case 'X': {
                return "LATIN CAPITAL LETTER X";
            }
            case 'Y': {
                return "LATIN CAPITAL LETTER Y";
            }
            case 'Z': {
                return "LATIN CAPITAL LETTER Z";
            }
            case '[': {
                return "LEFT SQUARE BRACKET";
            }
            case '\\': {
                return "REVERSE SOLIDUS";
            }
            case ']': {
                return "RIGHT SQUARE BRACKET";
            }
            case '^': {
                return "CIRCUMFLEX ACCENT";
            }
            case '_': {
                return "LOW LINE";
            }
            case '`': {
                return "GRAVE ACCENT";
            }
            case 'a': {
                return "LATIN SMALL LETTER A";
            }
            case 'b': {
                return "LATIN SMALL LETTER B";
            }
            case 'c': {
                return "LATIN SMALL LETTER C";
            }
            case 'd': {
                return "LATIN SMALL LETTER D";
            }
            case 'e': {
                return "LATIN SMALL LETTER E";
            }
            case 'f': {
                return "LATIN SMALL LETTER F";
            }
            case 'g': {
                return "LATIN SMALL LETTER G";
            }
            case 'h': {
                return "LATIN SMALL LETTER H";
            }
            case 'i': {
                return "LATIN SMALL LETTER I";
            }
            case 'j': {
                return "LATIN SMALL LETTER J";
            }
            case 'k': {
                return "LATIN SMALL LETTER K";
            }
            case 'l': {
                return "LATIN SMALL LETTER L";
            }
            case 'm': {
                return "LATIN SMALL LETTER M";
            }
            case 'n': {
                return "LATIN SMALL LETTER N";
            }
            case 'o': {
                return "LATIN SMALL LETTER O";
            }
            case 'p': {
                return "LATIN SMALL LETTER P";
            }
            case 'q': {
                return "LATIN SMALL LETTER Q";
            }
            case 'r': {
                return "LATIN SMALL LETTER R";
            }
            case 's': {
                return "LATIN SMALL LETTER S";
            }
            case 't': {
                return "LATIN SMALL LETTER T";
            }
            case 'u': {
                return "LATIN SMALL LETTER U";
            }
            case 'v': {
                return "LATIN SMALL LETTER V";
            }
            case 'w': {
                return "LATIN SMALL LETTER W";
            }
            case 'x': {
                return "LATIN SMALL LETTER X";
            }
            case 'y': {
                return "LATIN SMALL LETTER Y";
            }
            case 'z': {
                return "LATIN SMALL LETTER Z";
            }
            case '{': {
                return "LEFT CURLY BRACKET";
            }
            case '|': {
                return "VERTICAL LINE";
            }
            case '}': {
                return "RIGHT CURLY BRACKET";
            }
            case '~': {
                return "TILDE";
            }
            case '\u00a0': {
                return "NO-BREAK SPACE";
            }
            case '\u00a1': {
                return "INVERTED EXCLAMATION MARK";
            }
            case '\u00a2': {
                return "CENT SIGN";
            }
            case '\u00a3': {
                return "POUND SIGN";
            }
            case '\u00a4': {
                return "CURRENCY SIGN";
            }
            case '\u00a5': {
                return "YEN SIGN";
            }
            case '\u00a6': {
                return "BROKEN BAR";
            }
            case '\u00a7': {
                return "SECTION SIGN";
            }
            case '\u00a8': {
                return "DIAERESIS";
            }
            case '\u00a9': {
                return "COPYRIGHT SIGN";
            }
            case '\u00aa': {
                return "FEMININE ORDINAL INDICATOR";
            }
            case '\u00ac': {
                return "NOT SIGN";
            }
            case '\u00ad': {
                return "SOFT HYPHEN";
            }
            case '\u00ae': {
                return "REGISTERED SIGN";
            }
            case '\u00af': {
                return "MACRON";
            }
            case '\u00b0': {
                return "DEGREE SIGN";
            }
            case '\u00b1': {
                return "PLUS-MINUS SIGN";
            }
            case '\u00b2': {
                return "SUPERSCRIPT TWO";
            }
            case '\u00b3': {
                return "SUPERSCRIPT THREE";
            }
            case '\u00b4': {
                return "ACUTE ACCENT";
            }
            case '\u00b5': {
                return "MICRO SIGN";
            }
            case '\u00b6': {
                return "PILCROW SIGN";
            }
            case '\u00b7': {
                return "MIDDLE DOT";
            }
            case '\u00b8': {
                return "CEDILLA";
            }
            case '\u00b9': {
                return "SUPERSCRIPT ONE";
            }
            case '\u00ba': {
                return "MASCULINE ORDINAL INDICATOR";
            }
            case '\u00bc': {
                return "VULGAR FRACTION ONE QUARTER";
            }
            case '\u00bd': {
                return "VULGAR FRACTION ONE HALF";
            }
            case '\u00be': {
                return "VULGAR FRACTION THREE QUARTERS";
            }
            case '\u00bf': {
                return "INVERTED QUESTION MARK";
            }
            case '\u00c0': {
                return "LATIN CAPITAL LETTER A WITH GRAVE";
            }
            case '\u00c1': {
                return "LATIN CAPITAL LETTER A WITH ACUTE";
            }
            case '\u00c2': {
                return "LATIN CAPITAL LETTER A WITH CIRCUMFLEX";
            }
            case '\u00c3': {
                return "LATIN CAPITAL LETTER A WITH TILDE";
            }
            case '\u00c4': {
                return "LATIN CAPITAL LETTER A WITH DIAERESIS";
            }
            case '\u00c5': {
                return "LATIN CAPITAL LETTER A WITH RING ABOVE";
            }
            case '\u00c7': {
                return "LATIN CAPITAL LETTER C WITH CEDILLA";
            }
            case '\u00c8': {
                return "LATIN CAPITAL LETTER E WITH GRAVE";
            }
            case '\u00c9': {
                return "LATIN CAPITAL LETTER E WITH ACUTE";
            }
            case '\u00ca': {
                return "LATIN CAPITAL LETTER E WITH CIRCUMFLEX";
            }
            case '\u00cb': {
                return "LATIN CAPITAL LETTER E WITH DIAERESIS";
            }
            case '\u00cc': {
                return "LATIN CAPITAL LETTER I WITH GRAVE";
            }
            case '\u00cd': {
                return "LATIN CAPITAL LETTER I WITH ACUTE";
            }
            case '\u00ce': {
                return "LATIN CAPITAL LETTER I WITH CIRCUMFLEX";
            }
            case '\u00cf': {
                return "LATIN CAPITAL LETTER I WITH DIAERESIS";
            }
            case '\u00d1': {
                return "LATIN CAPITAL LETTER N WITH TILDE";
            }
            case '\u00d2': {
                return "LATIN CAPITAL LETTER O WITH GRAVE";
            }
            case '\u00d3': {
                return "LATIN CAPITAL LETTER O WITH ACUTE";
            }
            case '\u00d4': {
                return "LATIN CAPITAL LETTER O WITH CIRCUMFLEX";
            }
            case '\u00d5': {
                return "LATIN CAPITAL LETTER O WITH TILDE";
            }
            case '\u00d6': {
                return "LATIN CAPITAL LETTER O WITH DIAERESIS";
            }
            case '\u00d7': {
                return "MULTIPLICATION SIGN";
            }
            case '\u00d8': {
                return "LATIN CAPITAL LETTER O WITH STROKE";
            }
            case '\u00d9': {
                return "LATIN CAPITAL LETTER U WITH GRAVE";
            }
            case '\u00da': {
                return "LATIN CAPITAL LETTER U WITH ACUTE";
            }
            case '\u00db': {
                return "LATIN CAPITAL LETTER U WITH CIRCUMFLEX";
            }
            case '\u00dc': {
                return "LATIN CAPITAL LETTER U WITH DIAERESIS";
            }
            case '\u00dd': {
                return "LATIN CAPITAL LETTER Y WITH ACUTE";
            }
            case '\u00e0': {
                return "LATIN SMALL LETTER A WITH GRAVE";
            }
            case '\u00e1': {
                return "LATIN SMALL LETTER A WITH ACUTE";
            }
            case '\u00e2': {
                return "LATIN SMALL LETTER A WITH CIRCUMFLEX";
            }
            case '\u00e3': {
                return "LATIN SMALL LETTER A WITH TILDE";
            }
            case '\u00e4': {
                return "LATIN SMALL LETTER A WITH DIAERESIS";
            }
            case '\u00e5': {
                return "LATIN SMALL LETTER A WITH RING ABOVE";
            }
            case '\u00e7': {
                return "LATIN SMALL LETTER C WITH CEDILLA";
            }
            case '\u00e8': {
                return "LATIN SMALL LETTER E WITH GRAVE";
            }
            case '\u00e9': {
                return "LATIN SMALL LETTER E WITH ACUTE";
            }
            case '\u00ea': {
                return "LATIN SMALL LETTER E WITH CIRCUMFLEX";
            }
            case '\u00eb': {
                return "LATIN SMALL LETTER E WITH DIAERESIS";
            }
            case '\u00ec': {
                return "LATIN SMALL LETTER I WITH GRAVE";
            }
            case '\u00ed': {
                return "LATIN SMALL LETTER I WITH ACUTE";
            }
            case '\u00ee': {
                return "LATIN SMALL LETTER I WITH CIRCUMFLEX";
            }
            case '\u00ef': {
                return "LATIN SMALL LETTER I WITH DIAERESIS";
            }
            case '\u00f1': {
                return "LATIN SMALL LETTER N WITH TILDE";
            }
            case '\u00f2': {
                return "LATIN SMALL LETTER O WITH GRAVE";
            }
            case '\u00f3': {
                return "LATIN SMALL LETTER O WITH ACUTE";
            }
            case '\u00f4': {
                return "LATIN SMALL LETTER O WITH CIRCUMFLEX";
            }
            case '\u00f5': {
                return "LATIN SMALL LETTER O WITH TILDE";
            }
            case '\u00f6': {
                return "LATIN SMALL LETTER O WITH DIAERESIS";
            }
            case '\u00f7': {
                return "DIVISION SIGN";
            }
            case '\u00f8': {
                return "LATIN SMALL LETTER O WITH STROKE";
            }
            case '\u00f9': {
                return "LATIN SMALL LETTER U WITH GRAVE";
            }
            case '\u00fa': {
                return "LATIN SMALL LETTER U WITH ACUTE";
            }
            case '\u00fb': {
                return "LATIN SMALL LETTER U WITH CIRCUMFLEX";
            }
            case '\u00fc': {
                return "LATIN SMALL LETTER U WITH DIAERESIS";
            }
            case '\u00fd': {
                return "LATIN SMALL LETTER Y WITH ACUTE";
            }
            case '\u00ff': {
                return "LATIN SMALL LETTER Y WITH DIAERESIS";
            }
        }
        return null;
    }
}

