/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.ecore;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenClassGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenEnumGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenPackageGeneratorAdapter;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.util.LineFilterOutputStream;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractEcoreGeneratorFragment
extends AbstractGeneratorFragment {
    private static final Logger log = Logger.getLogger(AbstractEcoreGeneratorFragment.class);
    private String basePackage;
    private String xmiModelDirectory;
    private boolean generateEdit;
    private boolean generateEditor;

    public AbstractEcoreGeneratorFragment() {
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("genmodel")) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
        }
        GenModelPackage.eINSTANCE.getGenAnnotation();
        this.basePackage = null;
        this.xmiModelDirectory = null;
        this.generateEdit = false;
        this.generateEditor = false;
    }

    @Override
    public String[] getRequiredBundlesRt(Grammar grammar) {
        return new String[]{"org.eclipse.emf.ecore", "org.eclipse.emf.common"};
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Collections.singletonList(this.getBasePackage(grammar));
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        List typeSelect = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        LinkedHashSet<String> exportedPackages = new LinkedHashSet<String>();
        for (GeneratedMetamodel generatedMetamodel : typeSelect) {
            String modelPackage = Strings.skipLastToken((String)this.getGeneratedEPackageName(grammar, generatedMetamodel.getEPackage()), (String)".");
            exportedPackages.add(modelPackage);
            exportedPackages.add(String.valueOf(modelPackage) + ".impl");
            exportedPackages.add(String.valueOf(modelPackage) + ".util");
        }
        return exportedPackages.toArray(new String[exportedPackages.size()]);
    }

    protected void copyGeneratedMetamodelsTo(List<Grammar> list, ResourceSet rs, EcoreUtil.Copier copier) {
        ArrayList<EPackage> generatedEPackages = new ArrayList<EPackage>(3);
        this.collectGeneratedMetamodels(generatedEPackages, list, new HashSet<Grammar>());
        EcoreResourceFactoryImpl factory = new EcoreResourceFactoryImpl();
        for (EPackage copyMe : generatedEPackages) {
            Resource resource = factory.createResource(URI.createURI((String)copyMe.getNsURI()));
            resource.getContents().add((Object)copier.copy((EObject)copyMe));
            rs.getResources().add((Object)resource);
        }
    }

    private void collectGeneratedMetamodels(List<EPackage> generatedEPackages, List<Grammar> grammars, Set<Grammar> visited) {
        for (Grammar g : grammars) {
            if (!visited.add(g)) continue;
            for (AbstractMetamodelDeclaration decl : g.getMetamodelDeclarations()) {
                if (!(decl instanceof GeneratedMetamodel)) continue;
                generatedEPackages.add(decl.getEPackage());
            }
            this.collectGeneratedMetamodels(generatedEPackages, (List<Grammar>)g.getUsedGrammars(), visited);
        }
    }

    protected void doGenerate(GenModel genModel) {
        Diagnostic editorDiag;
        Diagnostic editDiag;
        Generator generator = new Generator();
        generator.getAdapterFactoryDescriptorRegistry().addDescriptor("http://www.eclipse.org/emf/2002/GenModel", new GeneratorAdapterFactory.Descriptor(){

            public GeneratorAdapterFactory createAdapterFactory() {
                return new GenModelGeneratorAdapterFactory(){

                    public Adapter createGenEnumAdapter() {
                        return new GenEnumGeneratorAdapter((GeneratorAdapterFactory)this){

                            protected OutputStream createOutputStream(URI workspacePath) throws Exception {
                                return AbstractEcoreGeneratorFragment.this.createOutputStream(super.createOutputStream(workspacePath), this.getLineDelimiter());
                            }
                        };
                    }

                    public Adapter createGenClassAdapter() {
                        return new GenClassGeneratorAdapter((GeneratorAdapterFactory)this){

                            protected OutputStream createOutputStream(URI workspacePath) throws Exception {
                                return AbstractEcoreGeneratorFragment.this.createOutputStream(super.createOutputStream(workspacePath), this.getLineDelimiter());
                            }
                        };
                    }

                    public Adapter createGenPackageAdapter() {
                        return new GenPackageGeneratorAdapter((GeneratorAdapterFactory)this){

                            protected OutputStream createOutputStream(URI workspacePath) throws Exception {
                                return AbstractEcoreGeneratorFragment.this.createOutputStream(super.createOutputStream(workspacePath), this.getLineDelimiter());
                            }
                        };
                    }

                    public Adapter createGenModelAdapter() {
                        if (this.genModelGeneratorAdapter == null) {
                            this.genModelGeneratorAdapter = new GenModelGeneratorAdapter((GeneratorAdapterFactory)this){

                                protected void generateModelBuildProperties(GenModel genModel, Monitor monitor) {
                                }

                                protected void generateModelManifest(GenModel genModel, Monitor monitor) {
                                }

                                protected void generateModelPluginProperties(GenModel genModel, Monitor monitor) {
                                }

                                protected void generateModelPluginClass(GenModel genModel, Monitor monitor) {
                                }
                            };
                        }
                        return this.genModelGeneratorAdapter;
                    }
                };
            }
        });
        generator.setInput((Object)genModel);
        Diagnostic diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor());
        if (diagnostic.getSeverity() != 0) {
            log.info((Object)diagnostic);
        }
        if (this.isGenerateEdit() && (editDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editDiag);
        }
        if (this.isGenerateEditor() && (editorDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editorDiag);
        }
    }

    public OutputStream createOutputStream(OutputStream stream, String lineDelimiter) throws Exception {
        return new LineFilterOutputStream(stream, " * $Id$", lineDelimiter != null ? lineDelimiter : Strings.newLine());
    }

    public void setBasePackage(String basePackage) {
        if ("".equals(basePackage.trim())) {
            return;
        }
        this.basePackage = basePackage;
    }

    public String getBasePackage(Grammar g) {
        if (this.basePackage == null) {
            return GrammarUtil.getNamespace((Grammar)g);
        }
        return this.basePackage;
    }

    public String getXmiModelDirectory() {
        return this.xmiModelDirectory;
    }

    public void setXmiModelDirectory(String dir) {
        this.xmiModelDirectory = dir;
    }

    public String getGeneratedEPackageName(Grammar g, EPackage pack) {
        return String.valueOf(this.getBasePackage(g)) + "." + pack.getName() + "." + Strings.toFirstUpper((String)pack.getName()) + "Package";
    }

    public void setGenerateEdit(boolean gen) {
        this.generateEdit = gen;
    }

    public void setGenerateEditor(boolean gen) {
        this.generateEditor = gen;
    }

    public boolean isGenerateEdit() {
        return this.generateEdit;
    }

    public boolean isGenerateEditor() {
        return this.generateEditor;
    }
}

