/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xtend.type.impl.java.JavaBeansMetaModel;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.XpandFacade;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.XtextStandaloneSetup;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.LanguageConfig;
import org.eclipse.xtext.generator.MergeableManifest;
import org.eclipse.xtext.generator.Naming;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends AbstractWorkflowComponent2 {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    public static final String SRC_GEN_UI = "SRC_GEN_UI";
    public static final String SRC_UI = "SRC_UI";
    public static final String PLUGIN_UI = "PLUGIN_UI";
    public static final String SRC = "SRC";
    public static final String SRC_GEN = "SRC_GEN";
    public static final String PLUGIN_RT = "PLUGIN";
    private String pathRtProject = ".";
    private String pathUiProject = null;
    private String srcPath = "/src";
    private String srcGenPath = "/src-gen";
    private final List<LanguageConfig> languageConfigs = new ArrayList<LanguageConfig>();
    private boolean mergeManifest = true;
    private String activator;
    private String projectNameRt;
    private String projectNameUi;

    public Generator() {
        new XtextStandaloneSetup().createInjectorAndDoEMFRegistration();
    }

    protected void checkConfigurationInternal(Issues issues) {
        for (LanguageConfig config : this.languageConfigs) {
            config.checkConfiguration(issues);
        }
        if (this.getProjectNameRt() == null) {
            issues.addError("The property 'projectNameRt' is mandatory");
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        new XtextStandaloneSetup().createInjectorAndDoEMFRegistration();
        try {
            XpandExecutionContext exeCtx = this.createExecutionContext();
            for (LanguageConfig config : this.languageConfigs) {
                this.generate(config, exeCtx);
                this.addToStandaloneSetup(config, exeCtx);
                this.generateGuiceModuleRt(config, exeCtx);
                if (!this.isUi()) continue;
                this.generateGuiceModuleUi(config, exeCtx);
                this.generateExecutableExtensionsFactory(config, exeCtx);
            }
            this.generatePluginXmlRt(this.languageConfigs, exeCtx);
            this.generateManifestRt(this.languageConfigs, exeCtx);
            if (this.isUi()) {
                this.generatePluginXmlUi(this.languageConfigs, exeCtx);
                this.generateManifestUi(this.languageConfigs, exeCtx);
                this.generateActivator(this.languageConfigs, exeCtx);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getPathRtProject() {
        return this.pathRtProject;
    }

    public void setPathRtProject(String pathRtProject) {
        this.pathRtProject = pathRtProject;
    }

    public String getPathUiProject() {
        return this.pathUiProject;
    }

    public void setPathUiProject(String pathUiProject) {
        this.pathUiProject = pathUiProject;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public String getSrcGenPath() {
        return this.srcGenPath;
    }

    public void setSrcGenPath(String srcGenPath) {
        this.srcGenPath = srcGenPath;
    }

    private XpandExecutionContext createExecutionContext() {
        OutputImpl output = new OutputImpl();
        output.addOutlet(new Outlet(false, this.getEncoding(), PLUGIN_RT, false, this.getPathRtProject()));
        output.addOutlet(new Outlet(false, this.getEncoding(), SRC, false, String.valueOf(this.getPathRtProject()) + this.getSrcPath()));
        output.addOutlet(new Outlet(false, this.getEncoding(), SRC_GEN, true, String.valueOf(this.getPathRtProject()) + this.getSrcGenPath()));
        if (this.isUi()) {
            output.addOutlet(new Outlet(false, this.getEncoding(), PLUGIN_UI, false, this.getPathUiProject()));
            output.addOutlet(new Outlet(false, this.getEncoding(), SRC_UI, false, String.valueOf(this.getPathUiProject()) + this.getSrcPath()));
            output.addOutlet(new Outlet(false, this.getEncoding(), SRC_GEN_UI, true, String.valueOf(this.getPathUiProject()) + this.getSrcGenPath()));
        } else {
            output.addOutlet(new Outlet(false, this.getEncoding(), PLUGIN_UI, false, this.getPathRtProject()));
            output.addOutlet(new Outlet(false, this.getEncoding(), SRC_UI, false, String.valueOf(this.getPathRtProject()) + this.getSrcPath()));
            output.addOutlet(new Outlet(false, this.getEncoding(), SRC_GEN_UI, true, String.valueOf(this.getPathRtProject()) + this.getSrcGenPath()));
        }
        XpandExecutionContextImpl execCtx = new XpandExecutionContextImpl((Output)output, null);
        execCtx.setFileEncoding("ISO-8859-1");
        execCtx.registerMetaModel((MetaModel)new JavaBeansMetaModel());
        execCtx = (XpandExecutionContextImpl)execCtx.cloneWithVariable(new Variable("modelPluginID", (Object)this.getProjectNameRt()));
        return execCtx;
    }

    private String getEncoding() {
        return System.getProperty("file.encoding");
    }

    public void addLanguage(LanguageConfig langConfig) {
        langConfig.initialize(this.isUi());
        this.languageConfigs.add(langConfig);
    }

    private List<Grammar> getGrammars(List<LanguageConfig> configs) {
        ArrayList<Grammar> grammars = new ArrayList<Grammar>();
        for (LanguageConfig conf : configs) {
            grammars.add(conf.getGrammar());
        }
        return grammars;
    }

    private void generatePluginXmlRt(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        String filePath = this.fileExists(ctx, "plugin.xml", PLUGIN_RT) ? "plugin.xml_gen" : "plugin.xml";
        this.deleteFile(ctx, filePath, PLUGIN_RT);
        ctx.getOutput().openFile(filePath, PLUGIN_RT);
        try {
            XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
            List<Grammar> grammars = this.getGrammars(configs);
            facade.evaluate("org::eclipse::xtext::generator::Plugin::pre", grammars, new Object[0]);
            for (LanguageConfig conf : this.languageConfigs) {
                conf.addToPluginXmlRt(conf.getGrammar(), ctx);
                if (!this.isMergedProjects()) continue;
                conf.addToPluginXmlUi(conf.getGrammar(), ctx);
            }
            facade.evaluate("org::eclipse::xtext::generator::Plugin::post", grammars, new Object[0]);
        }
        finally {
            ctx.getOutput().closeFile();
        }
    }

    private void generateExecutableExtensionsFactory(LanguageConfig config, XpandExecutionContext exeCtx) {
        XpandFacade facade = XpandFacade.create((XpandExecutionContext)exeCtx);
        facade.evaluate("org::eclipse::xtext::generator::ExecutableExtensionFactory::file", (Object)config.getGrammar(), new Object[]{this.getActivator()});
    }

    private void generateActivator(List<LanguageConfig> configs, XpandExecutionContext exeCtx) {
        XpandFacade facade = XpandFacade.create((XpandExecutionContext)exeCtx);
        facade.evaluate("org::eclipse::xtext::generator::Activator::file", this.getGrammars(configs), new Object[]{this.getActivator()});
    }

    private void generatePluginXmlUi(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        if (this.isUi() && !this.isMergedProjects()) {
            String filePath = this.fileExists(ctx, "plugin.xml", PLUGIN_UI) ? "plugin.xml_gen" : "plugin.xml";
            this.deleteFile(ctx, filePath, PLUGIN_UI);
            ctx.getOutput().openFile(filePath, PLUGIN_UI);
            try {
                XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
                List<Grammar> grammars = this.getGrammars(configs);
                facade.evaluate("org::eclipse::xtext::generator::Plugin::pre", grammars, new Object[0]);
                for (LanguageConfig conf : this.languageConfigs) {
                    conf.addToPluginXmlUi(conf.getGrammar(), ctx);
                }
                facade.evaluate("org::eclipse::xtext::generator::Plugin::post", grammars, new Object[0]);
            }
            finally {
                ctx.getOutput().closeFile();
            }
        }
    }

    private void addToStandaloneSetup(LanguageConfig config, XpandExecutionContext ctx) {
        ctx.getOutput().openFile(String.valueOf(Naming.asPath(Naming.setup(config.getGrammar()))) + ".java", SRC_GEN);
        try {
            XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
            facade.evaluate("org::eclipse::xtext::generator::StandaloneSetup::pre", (Object)config.getGrammar(), new Object[0]);
            config.addToStandaloneSetup(config.getGrammar(), ctx);
            facade.evaluate("org::eclipse::xtext::generator::StandaloneSetup::post", (Object)config.getGrammar(), new Object[0]);
        }
        finally {
            ctx.getOutput().closeFile();
        }
    }

    private void generateGuiceModuleRt(LanguageConfig config, XpandExecutionContext ctx) {
        XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
        Set<Binding> bindings = config.getGuiceBindingsRt(config.getGrammar());
        facade.evaluate("org::eclipse::xtext::generator::GuiceModuleRt::generate", (Object)config.getGrammar(), new Object[]{bindings});
    }

    private void generateGuiceModuleUi(LanguageConfig config, XpandExecutionContext ctx) {
        if (this.isUi()) {
            XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
            Set<Binding> bindings = config.getGuiceBindingsUi(config.getGrammar());
            facade.evaluate("org::eclipse::xtext::generator::GuiceModuleUi::generate", (Object)config.getGrammar(), new Object[]{bindings});
        }
    }

    private boolean isUi() {
        return this.getPathUiProject() != null;
    }

    private void generate(LanguageConfig config, XpandExecutionContext ctx) {
        config.generate(config.getGrammar(), ctx);
    }

    private void generateManifestRt(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        String manifestPath = "META-INF/MANIFEST.MF";
        LinkedHashSet<String> exported = new LinkedHashSet<String>();
        LinkedHashSet<String> requiredBundles = new LinkedHashSet<String>();
        String activator = null;
        if (this.isMergedProjects()) {
            activator = this.getActivator();
        }
        for (LanguageConfig config : configs) {
            exported.addAll(Arrays.asList(config.getExportedPackagesRt(config.getGrammar())));
            requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesRt(config.getGrammar())));
            if (!this.isMergedProjects()) continue;
            exported.addAll(Arrays.asList(config.getExportedPackagesUi(config.getGrammar())));
            requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesUi(config.getGrammar())));
        }
        if (this.isMergeManifest()) {
            String path = String.valueOf(ctx.getOutput().getOutlet(PLUGIN_RT).getPath()) + "/" + manifestPath;
            this.mergeManifest(this.getProjectNameRt(), path, exported, requiredBundles, activator);
        } else {
            manifestPath = String.valueOf(manifestPath) + "_gen";
            this.deleteFile(ctx, manifestPath, PLUGIN_RT);
            ctx.getOutput().openFile(manifestPath, PLUGIN_RT);
            try {
                XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
                this.generateManifest(facade, this.getProjectNameRt(), this.getProjectNameRt(), this.getBundleVersion(), exported, requiredBundles, activator);
            }
            finally {
                ctx.getOutput().closeFile();
            }
        }
    }

    private void mergeManifest(String projectName, String path, Set<String> exported, Set<String> requiredBundles, String activator) {
        File file = new File(path);
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(file);
                MergeableManifest manifest = new MergeableManifest(in, projectName);
                manifest.addExportedPackages(exported);
                manifest.addRequiredBundles(requiredBundles);
                if (activator != null && !manifest.getMainAttributes().containsKey(MergeableManifest.BUNDLE_ACTIVATOR)) {
                    manifest.getMainAttributes().put(MergeableManifest.BUNDLE_ACTIVATOR, activator);
                }
                if (manifest.isModified()) {
                    out = new FileOutputStream(file);
                    manifest.write(out);
                    out.close();
                }
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
    }

    public void setMergeManifest(boolean mergeManifest) {
        this.mergeManifest = mergeManifest;
    }

    private boolean isMergeManifest() {
        return this.mergeManifest;
    }

    private void generateManifestUi(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        if (this.isUi() && !this.isMergedProjects()) {
            String manifestPath = "META-INF/MANIFEST.MF";
            LinkedHashSet<String> exported = new LinkedHashSet<String>();
            LinkedHashSet<String> requiredBundles = new LinkedHashSet<String>();
            for (LanguageConfig config : this.languageConfigs) {
                exported.addAll(Arrays.asList(config.getExportedPackagesUi(config.getGrammar())));
                requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesUi(config.getGrammar())));
            }
            if (this.isMergeManifest()) {
                String path = String.valueOf(ctx.getOutput().getOutlet(PLUGIN_UI).getPath()) + "/" + manifestPath;
                this.mergeManifest(this.getProjectNameUi(), path, exported, requiredBundles, this.getActivator());
            } else {
                manifestPath = String.valueOf(manifestPath) + "_gen";
                this.deleteFile(ctx, manifestPath, PLUGIN_UI);
                ctx.getOutput().openFile(manifestPath, PLUGIN_UI);
                try {
                    XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
                    this.generateManifest(facade, this.getProjectNameUi(), this.getProjectNameUi(), this.getBundleVersion(), exported, requiredBundles, this.getActivator());
                }
                finally {
                    ctx.getOutput().closeFile();
                }
            }
        }
    }

    private void deleteFile(XpandExecutionContext ctx, String filePath, String outlet) {
        String pathname = String.valueOf(ctx.getOutput().getOutlet(outlet).getPath()) + "/" + filePath;
        File file = new File(pathname);
        if (file.exists() && !file.delete()) {
            throw new IllegalStateException("couldn't delete file '" + pathname);
        }
    }

    private boolean fileExists(XpandExecutionContext ctx, String filePath, String outlet) {
        String pathname = String.valueOf(ctx.getOutput().getOutlet(outlet).getPath()) + "/" + filePath;
        File file = new File(pathname);
        return file.exists();
    }

    private boolean isMergedProjects() {
        return this.getPathRtProject().equals(this.getPathUiProject());
    }

    private String getBundleVersion() {
        return "0.0.1";
    }

    public void setProjectNameRt(String projectNameRt) {
        this.projectNameRt = projectNameRt;
    }

    private String getProjectNameRt() {
        return this.projectNameRt;
    }

    public void setProjectNameUi(String projectNameUi) {
        this.projectNameUi = projectNameUi;
    }

    private String getProjectNameUi() {
        if (this.projectNameUi == null) {
            return String.valueOf(this.getProjectNameRt()) + ".ui";
        }
        return this.projectNameUi;
    }

    private void generateManifest(XpandFacade facade, String name, String symbolicName, String version, Set<String> exported, Set<String> requiredBundles, String activator) {
        facade.evaluate("org::eclipse::xtext::generator::Manifest::file", (Object)name, new Object[]{symbolicName, version, exported, requiredBundles, activator});
    }

    public void setActivator(String activator) {
        this.activator = activator;
    }

    private String getActivator() {
        if (this.activator == null) {
            Grammar grammar = this.languageConfigs.get(0).getGrammar();
            return String.valueOf(GrammarUtil.getNamespace((Grammar)grammar)) + ".internal." + GrammarUtil.getName((Grammar)grammar) + "Activator";
        }
        return this.activator;
    }
}

