/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.visualisation;

import eu.qimpress.samm.visualisation.RepositoryVizEditorInput;
import eu.qimpress.samm.visualisation.RepositoryVizNode;
import eu.qimpress.samm.visualisation.myContentProposalProvider;
import java.util.Collection;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class NodeSearchDialog
extends InputDialog {
    private RepositoryVizEditorInput vizData;
    private RepositoryVizNode selectedNode;
    private String textBoxContent;

    public NodeSearchDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, RepositoryVizEditorInput input) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        this.vizData = input;
    }

    protected Control createDialogArea(Composite parent) {
        Composite myDialogArea = (Composite)super.createDialogArea(parent);
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.getText(), (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new myContentProposalProvider(this.vizData), keyStroke, null);
            adapter.setProposalAcceptanceStyle(2);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return myDialogArea;
    }

    public RepositoryVizNode getSelectedNode() {
        String nodeName = this.getValue();
        Collection<RepositoryVizNode> listOfNodes = this.vizData.getTree().getLisOfNodes().values();
        for (RepositoryVizNode node : listOfNodes) {
            if (!node.getName().equalsIgnoreCase(nodeName)) continue;
            return node;
        }
        return null;
    }
}

