/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.seff.part;

import eu.qimpress.ide.editors.gmf.seff.part.Messages;
import eu.qimpress.ide.editors.gmf.seff.part.SeffCreationWizardPage;
import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorPlugin;
import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SeffCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected SeffCreationWizardPage diagramModelFilePage;
    protected SeffCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.SeffCreationWizardTitle);
        this.setDefaultPageImageDescriptor(SeffDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewseffWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new SeffCreationWizardPage("DiagramModelFile", this.getSelection(), "samm_seff_diagram");
        this.diagramModelFilePage.setTitle(Messages.SeffCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.SeffCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new SeffCreationWizardPage("DomainModelFile", this.getSelection(), "samm_seff"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = SeffCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".samm_seff_diagram".length());
                    this.setFileName(SeffDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "samm_seff"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.SeffCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.SeffCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                SeffCreationWizard.this.diagram = SeffDiagramEditorUtil.createDiagram(SeffCreationWizard.this.diagramModelFilePage.getURI(), SeffCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (SeffCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && SeffCreationWizard.this.diagram != null) {
                    try {
                        SeffDiagramEditorUtil.openDiagram(SeffCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)SeffCreationWizard.this.getContainer().getShell(), (String)Messages.SeffCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.SeffCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                SeffDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

