/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.seff.part;

import eu.qimpress.ide.editors.gmf.seff.part.BlackboardListener;
import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorPlugin;
import eu.qimpress.ide.editors.gmf.seff.part.SeffNewDiagramFileBlackboard;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.impl.PrimitiveComponentImpl;
import eu.qimpress.seff.SeffRepository;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class ComponentSelectorPage
extends WizardPage {
    SeffNewDiagramFileBlackboard blackboard;
    protected EObject selectedModelElement;
    private TreeViewer modelViewer;

    protected ComponentSelectorPage(SeffRepository seffRepository, SeffNewDiagramFileBlackboard blackboard) {
        super("Select operation");
        this.blackboard = blackboard;
        this.setTitle("Diagram Operation");
        this.setDescription("Select the component to be used for the diagram.");
    }

    public void setModelElement(EObject modelElement) {
        this.selectedModelElement = modelElement;
        if (this.modelViewer != null) {
            if (this.selectedModelElement != null) {
                this.modelViewer.setInput((Object)this.selectedModelElement.eResource());
                this.modelViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedModelElement));
            } else {
                this.modelViewer.setInput(null);
            }
            this.setPageComplete(this.validatePage());
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite plate = new Composite(parent, 0);
        plate.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        plate.setLayout((Layout)layout);
        this.setControl((Control)plate);
        Label label = new Label(plate, 0);
        label.setLayoutData((Object)new GridData(32));
        this.modelViewer = new TreeViewer(plate, 2820);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.modelViewer.getTree().setLayoutData((Object)layoutData);
        this.modelViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(SeffDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()));
        this.modelViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(SeffDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()));
        this.blackboard.addBlackboardListener(new BlackboardListener(){

            @Override
            public void componentChanged() {
            }

            @Override
            public void filenameChanged() {
            }

            @Override
            public void repositoryChanged() {
                if (ComponentSelectorPage.this.blackboard.getRepository() != null) {
                    ComponentSelectorPage.this.modelViewer.setInput((Object)ComponentSelectorPage.this.blackboard.getRepository().eResource());
                }
            }
        });
        if (this.blackboard.getRepository() != null) {
            this.modelViewer.setInput((Object)this.blackboard.getRepository().eResource());
        }
        this.modelViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComponentSelectorPage.this.updateSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.setPageComplete(this.validatePage());
    }

    protected void updateSelection(IStructuredSelection selection) {
        this.selectedModelElement = null;
        if (selection.size() == 1) {
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof IWrapperItemProvider) {
                selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
            }
            if (selectedElement instanceof FeatureMap.Entry) {
                selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
            }
            if (selectedElement instanceof EObject) {
                this.selectedModelElement = (EObject)selectedElement;
            }
        }
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        if (this.selectedModelElement == null) {
            this.setErrorMessage("No component selected");
            return false;
        }
        if (!(this.selectedModelElement instanceof PrimitiveComponentImpl)) {
            this.setErrorMessage("Wrong resource type selected");
            return false;
        }
        this.setErrorMessage(null);
        this.blackboard.setComponent((ComponentType)this.selectedModelElement);
        return true;
    }
}

