/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.form.qoseditor.wizards.widgets;

import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.ui.models.adapters.QModelsComposedAdapterFactoryProvider;
import eu.qimpress.ide.editors.form.qoseditor.wizards.widgets.annotableTreeContentProvider;
import eu.qimpress.ide.editors.form.qoseditor.wizards.widgets.entityViewerInfo;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;

public class AnnotableEntitiesViewer
extends CheckboxTreeViewer {
    public Object[] selectedEntities;
    public Object[] initialyAnnotatedEntities;
    int currentAnnotationIndex = -1;

    public AnnotableEntitiesViewer(Composite parent, int style, int numAnnotations) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new annotableTreeContentProvider());
        this.setInput(new entityViewerInfo(null, null));
        this.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)QModelsComposedAdapterFactoryProvider.getInstance().getAdapterFactory()));
        this.selectedEntities = new Object[numAnnotations];
        int i = 0;
        while (i < numAnnotations) {
            this.selectedEntities[i] = new ArrayList();
            ++i;
        }
        this.initialyAnnotatedEntities = new Object[numAnnotations];
        i = 0;
        while (i < numAnnotations) {
            this.initialyAnnotatedEntities[i] = new ArrayList();
            ++i;
        }
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
    }

    public void saveCurrentSelection() {
        if (this.currentAnnotationIndex != -1) {
            ArrayList<EObject> selectedEntitiesForAnnotationIndex = new ArrayList<EObject>();
            int i = 0;
            while (i < this.getCheckedElements().length) {
                selectedEntitiesForAnnotationIndex.add((EObject)this.getCheckedElements()[i]);
                ++i;
            }
            this.selectedEntities[this.currentAnnotationIndex] = selectedEntitiesForAnnotationIndex;
        }
    }

    public void restorePreviousSelection() {
        this.refresh();
        this.setAllChecked(false);
        if (this.currentAnnotationIndex != -1) {
            int i = 0;
            while (i < ((ArrayList)this.selectedEntities[this.currentAnnotationIndex]).size()) {
                this.setChecked(((ArrayList)this.selectedEntities[this.currentAnnotationIndex]).get(i), true);
                ++i;
            }
        }
    }

    public void selectedAnotationChanged(EClass annTypeA, IQProject projectA, int annIndex) {
        if (this.currentAnnotationIndex != annIndex) {
            this.saveCurrentSelection();
            this.currentAnnotationIndex = annIndex;
            this.setInput(new entityViewerInfo(annTypeA, projectA));
            this.restorePreviousSelection();
        }
    }

    public EObject getSelectedEObject() {
        Object o;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty() && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return (EObject)o;
        }
        return null;
    }
}

