/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.form.qoseditor.wizards;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.operations.SaveQModelUIOperation;
import eu.qimpress.ide.editors.form.qoseditor.QoSEditorUtils;
import eu.qimpress.ide.editors.form.qoseditor.properties.AssociatedQoSAnnotationSection;
import eu.qimpress.ide.editors.form.qoseditor.wizards.AnnotationCouple;
import eu.qimpress.ide.editors.form.qoseditor.wizards.pages.AnnotationInstanceEditorPage;
import eu.qimpress.ide.editors.form.qoseditor.wizards.pages.SelectAnnotationAndEntitiesPage;
import eu.qimpress.ide.editors.form.qoseditor.wizards.pages.SelectProjectPage;
import eu.qimpress.samm.qosannotation.Annotation;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class QoSAnnotationWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection initialSelection;
    public SelectProjectPage selectProjectPage;
    private SelectAnnotationAndEntitiesPage selectAnnotationAndEntitiesPage;
    private IQProject initialSelectedProject;
    public static final Logger logger = Logger.getLogger(AssociatedQoSAnnotationSection.class);
    public static final String WIZARD_ID = "eu.qimpress.ide.editors.form.qoseditor.QoSAnnotationWizardID";
    private ArrayList<AnnotationCouple> annotationCouples = new ArrayList();
    private int coupleIndex = 0;
    public EClass[] annotationTypes = QoSEditorUtils.getDefinedAnnotationsTypes();

    public boolean performFinishOld() {
        IQProject project = this.selectProjectPage.getSelectedProject();
        EClass[] eClassArray = this.annotationTypes;
        int n = this.annotationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EObject[] entitiesToAnnotate;
            EClass annType = eClassArray[n2];
            EObject[] eObjectArray = entitiesToAnnotate = this.selectAnnotationAndEntitiesPage.getSelectedEntitiesForAnnoataionType(annType);
            int n3 = entitiesToAnnotate.length;
            int n4 = 0;
            while (n4 < n3) {
                EObject entityToAnnotate = eObjectArray[n4];
                try {
                    Annotation annotation = QoSEditorUtils.addNewAnnotation(project.getProject(), annType);
                    QoSEditorUtils.setAnnotationReference(annotation, entityToAnnotate);
                }
                catch (RepositoryException e) {
                    logger.error((Object)("Annotation Wizard: Repository Exception, " + e.getMessage()));
                }
                ++n4;
            }
            ++n2;
        }
        try {
            IQModel annotationModel = project.getRepository().getDefaultAlternative().getModel("samm_qosannotation");
            this.getContainer().run(false, false, (IRunnableWithProgress)new SaveQModelUIOperation(annotationModel));
        }
        catch (Exception e) {
            logger.error((Object)("Annotation Wizard: Can not get container, " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        IWizardPage[] pages;
        IQProject project = this.selectProjectPage.getSelectedProject();
        IWizardPage[] iWizardPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage pg = iWizardPageArray[n2];
            if (pg != null && pg instanceof AnnotationInstanceEditorPage) {
                System.out.println("ANNOTATION WIZARD.FINISH: Annotating [ID = " + ((AnnotationInstanceEditorPage)pg).pageId + "] " + ((AnnotationInstanceEditorPage)pg).entityToAnnotate + " by " + ((AnnotationInstanceEditorPage)pg).annotationInstance.getName());
                try {
                    QoSEditorUtils.addNewAnnotationInstance(project.getProject(), ((AnnotationInstanceEditorPage)pg).annotationInstance);
                    QoSEditorUtils.setAnnotationReference(((AnnotationInstanceEditorPage)pg).annotationInstance, ((AnnotationInstanceEditorPage)pg).entityToAnnotate);
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                    logger.error((Object)("Annotation Wizard: Repository Exception, " + e.getMessage()));
                }
            }
            ++n2;
        }
        try {
            IQModel annotationModel = project.getRepository().getDefaultAlternative().getModel("samm_qosannotation");
            this.getContainer().run(false, false, (IRunnableWithProgress)new SaveQModelUIOperation(annotationModel));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Annotation Wizard: Can not get container, " + e.getMessage()));
            return false;
        }
        return true;
    }

    public void addPages() {
        this.initialSelectedProject = null;
        if (this.initialSelection.size() == 1) {
            IResource res;
            Object o = this.initialSelection.getFirstElement();
            IProject project = null;
            if (o instanceof IResource) {
                project = ((IResource)o).getProject();
            } else if (o instanceof IAdaptable && (res = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null) {
                project = res.getProject();
            }
            this.initialSelectedProject = QImpressCore.getQProject((IProject)project);
        }
        this.initialSelectedProject = null;
        this.selectProjectPage = new SelectProjectPage(this.initialSelectedProject);
        this.addPage((IWizardPage)this.selectProjectPage);
        this.selectAnnotationAndEntitiesPage = new SelectAnnotationAndEntitiesPage(this.initialSelectedProject);
        this.addPage((IWizardPage)this.selectAnnotationAndEntitiesPage);
        Point size = this.getContainer().getShell().getSize();
        this.getContainer().getShell().setSize(size.x + size.x / 3, size.y + size.y / 4);
    }

    private void generateCouples() {
        EClass[] annotationTypes = QoSEditorUtils.getDefinedAnnotationsTypes();
        this.annotationCouples = new ArrayList();
        EClass[] eClassArray = annotationTypes;
        int n = annotationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EObject[] entitiesToAnnotate;
            EClass annType = eClassArray[n2];
            EObject[] eObjectArray = entitiesToAnnotate = this.selectAnnotationAndEntitiesPage.getSelectedEntitiesForAnnoataionType(annType);
            int n3 = entitiesToAnnotate.length;
            int n4 = 0;
            while (n4 < n3) {
                EObject entityToAnnotate = eObjectArray[n4];
                this.annotationCouples.add(new AnnotationCouple(annType, entityToAnnotate));
                ++n4;
            }
            ++n2;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof SelectAnnotationAndEntitiesPage) {
            this.generateCouples();
            while (this.coupleIndex < this.annotationCouples.size()) {
                AnnotationInstanceEditorPage newPage = new AnnotationInstanceEditorPage();
                newPage.setAnnotationTypeAndObject(this.annotationCouples.get((int)this.coupleIndex).annotationType, this.annotationCouples.get((int)this.coupleIndex).entity);
                newPage.setPageId(this.coupleIndex);
                ++this.coupleIndex;
                this.addPage((IWizardPage)newPage);
            }
        }
        return super.getNextPage(page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
    }
}

