/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.form.qoseditor.properties;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.operations.SaveQModelUIOperation;
import eu.qimpress.ide.backbone.core.ui.models.adapters.QModelsComposedAdapterFactoryProvider;
import eu.qimpress.ide.editors.form.qoseditor.QoSEditorUtils;
import eu.qimpress.samm.qosannotation.Annotation;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AssociatedQoSAnnotationSection
extends AbstractPropertySection {
    private static final Logger logger = Logger.getLogger(AssociatedQoSAnnotationSection.class);
    protected Composite composite;
    protected Group annotationListGroup;
    protected Group annotationInfoGroup;
    protected PropertySheetPage annotationPage;
    protected List annotationList;
    protected Button createNewAnnotationButton;
    protected Button addAnnotationButton;
    protected Button saveAnnotationButton;
    private EObject selectedEntity;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        this.annotationPage.selectionChanged(part, (ISelection)new StructuredSelection());
        this.selectedEntity = null;
        if (selection instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)selection).getFirstElement();
            this.selectedEntity = this.transformSelection(o);
        }
        super.setInput(part, (ISelection)new StructuredSelection((Object)this.selectedEntity));
    }

    protected EObject transformSelection(Object o) {
        if (o instanceof EObject) {
            return (EObject)o;
        }
        if (o instanceof EditPart) {
            Object model = ((EditPart)o).getModel();
            return model instanceof View ? ((View)model).getElement() : null;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.initializeControls(parent, aTabbedPropertySheetPage);
    }

    protected void initializeControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.composite = parent;
        Composite groups = this.getWidgetFactory().createComposite(this.composite);
        groups.setLayout((Layout)new GridLayout(1, false));
        this.createAnnotationListGroup(groups);
        this.annotationListGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createAnnotationInfoGroup(groups, aTabbedPropertySheetPage);
        this.annotationInfoGroup.setLayoutData((Object)new GridData(4, 1, false, true));
    }

    private Group createAnnotationListGroup(Composite parent) {
        this.annotationListGroup = this.getWidgetFactory().createGroup(parent, "Associated annotations");
        GridLayout layout = new GridLayout(2, false);
        this.annotationListGroup.setLayout((Layout)layout);
        this.annotationList = this.getWidgetFactory().createList((Composite)this.annotationListGroup, 2052);
        GridDataFactory.fillDefaults().span(1, 2).grab(true, true).applyTo((Control)this.annotationList);
        this.annotationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AssociatedQoSAnnotationSection.this.annotationList.getSelectionIndex() != -1) {
                    Annotation annotation = ((Annotation[])AssociatedQoSAnnotationSection.this.annotationList.getData())[AssociatedQoSAnnotationSection.this.annotationList.getSelectionIndex()];
                    AssociatedQoSAnnotationSection.this.annotationPage.selectionChanged(null, (ISelection)new StructuredSelection(new Object[]{annotation}));
                    AssociatedQoSAnnotationSection.this.saveAnnotationButton.setEnabled(true);
                }
            }
        });
        this.addAnnotationButton = new Button((Composite)this.annotationListGroup, 8);
        this.addAnnotationButton.setText("Add ...");
        this.addAnnotationButton.setToolTipText("Associated annotation with the element ");
        this.addAnnotationButton.setLayoutData((Object)new GridData(32));
        this.addAnnotationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject project = QImpressCore.getProject((URI)AssociatedQoSAnnotationSection.this.selectedEntity.eResource().getURI());
                if (project != null) {
                    AssociatedQoSAnnotationSection.this.handleAddAnnotationButton(project, e.widget.getDisplay().getActiveShell());
                } else {
                    AssociatedQoSAnnotationSection.this.handleNullProject(e.display.getActiveShell(), "Error occured");
                }
            }
        });
        this.createNewAnnotationButton = new Button((Composite)this.annotationListGroup, 8);
        this.createNewAnnotationButton.setText("New ...");
        this.createNewAnnotationButton.setToolTipText("Create new annotation");
        this.createNewAnnotationButton.setLayoutData((Object)new GridData(32));
        this.createNewAnnotationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject project = QImpressCore.getProject((URI)AssociatedQoSAnnotationSection.this.selectedEntity.eResource().getURI());
                if (project != null) {
                    AssociatedQoSAnnotationSection.this.handleCreateNewAnnotationButton(project, e.display.getActiveShell());
                } else {
                    AssociatedQoSAnnotationSection.this.handleNullProject(e.display.getActiveShell(), "Error occured");
                }
            }
        });
        return this.annotationListGroup;
    }

    private Group createAnnotationInfoGroup(Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.annotationInfoGroup = this.getWidgetFactory().createGroup(parent, "Annotation info");
        GridLayout layout = new GridLayout(2, false);
        this.annotationInfoGroup.setLayout((Layout)layout);
        Composite pSheetComposite = this.getWidgetFactory().createFlatFormComposite((Composite)this.annotationInfoGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)pSheetComposite);
        this.annotationPage = new PropertySheetPage();
        this.annotationPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)QModelsComposedAdapterFactoryProvider.getInstance().getAdapterFactory()));
        this.annotationPage.createControl(pSheetComposite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.height = 150;
        this.annotationPage.getControl().setLayoutData((Object)data);
        this.annotationPage.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                aTabbedPropertySheetPage.resizeScrolledComposite();
            }
        });
        this.saveAnnotationButton = new Button((Composite)this.annotationInfoGroup, 8);
        this.saveAnnotationButton.setText("Save");
        this.saveAnnotationButton.setToolTipText("Save annotation changes");
        this.saveAnnotationButton.setLayoutData((Object)new GridData(34));
        this.saveAnnotationButton.setEnabled(false);
        this.saveAnnotationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject project = QImpressCore.getProject((URI)AssociatedQoSAnnotationSection.this.selectedEntity.eResource().getURI());
                Shell shell = e.display.getActiveShell();
                AssociatedQoSAnnotationSection.this.handleAnnotationSaveButton(project, shell);
            }
        });
        return this.annotationInfoGroup;
    }

    protected void handleAnnotationSaveButton(IProject project, Shell shell) {
        IQModel qModel = null;
        try {
            qModel = QImpressCore.getQProject((IProject)project).getRepository().getDefaultAlternative().getModel("samm_qosannotation");
            SaveQModelUIOperation saveOperation = new SaveQModelUIOperation(qModel);
            saveOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            logger.error((Object)("Cannot save annotation model: qModel:" + qModel), (Throwable)e);
            MessageDialog.openError((Shell)shell, (String)"Annotation model save", (String)("Cannot save annotation model because of " + e.getMessage()));
        }
    }

    public void refresh() {
        if (this.selectedEntity != null) {
            try {
                Annotation[] annotations = QoSEditorUtils.getAttachedAnnotations(this.selectedEntity);
                this.annotationList.removeAll();
                StringBuilder sb = new StringBuilder();
                Annotation[] annotationArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation annotation = annotationArray[n2];
                    QoSEditorUtils.getAnnotationLabel(annotation, sb);
                    String key = sb.toString();
                    this.annotationList.add(key);
                    ++n2;
                }
                this.annotationList.setData((Object)annotations);
            }
            catch (RepositoryException e) {
                logger.debug((Object)("Cannot get a list of annotations attached to element " + this.selectedEntity), (Throwable)e);
            }
        }
    }

    protected void handleAddAnnotationButton(IProject project, Shell shell) {
        assert (project != null);
        Annotation annotation = null;
        try {
            project = QImpressCore.getProject((URI)this.selectedEntity.eResource().getURI());
            annotation = QoSEditorUtils.browseForAnnotationInstance(shell, QoSEditorUtils.getAccessibleAnnotationsForType(project, this.selectedEntity.getClass()), null);
        }
        catch (RepositoryException ex) {
            MessageDialog.openError((Shell)shell, (String)"Cannot open instance browser", (String)"Error occured during annotation instance browser opening");
            logger.error((Object)("Cannot get a list of accesible annotations for entity " + this.selectedEntity), (Throwable)ex);
        }
        if (annotation == null) {
            return;
        }
        if (!QoSEditorUtils.setAnnotationReference(annotation, this.selectedEntity)) {
            logger.warn((Object)("Cannot setup reference [" + this.selectedEntity + "] for annotation:" + annotation));
        } else {
            this.refresh();
        }
    }

    protected void handleCreateNewAnnotationButton(IProject project, Shell shell) {
        assert (project != null);
        EClass eClazz = QoSEditorUtils.browseForAnnotationType(shell, QoSEditorUtils.getAnnotationTypesForType(this.selectedEntity.getClass()), null);
        if (eClazz == null) {
            return;
        }
        try {
            Annotation annotation = QoSEditorUtils.addNewAnnotation(project, eClazz);
            if (annotation != null) {
                if (!QoSEditorUtils.setAnnotationReference(annotation, this.selectedEntity)) {
                    logger.warn((Object)("Cannot setup reference [" + this.selectedEntity + "] for annotation:" + annotation));
                } else {
                    this.refresh();
                }
            }
        }
        catch (RepositoryException e) {
            MessageDialog.openError((Shell)shell, (String)"Create new annotation", (String)"Error occured during new annotation creation");
            logger.error((Object)"Cannot create new annotation in the default alternative", (Throwable)e);
        }
    }

    protected void handleNullProject(Shell shell, String title) {
        MessageDialog.openError((Shell)shell, (String)title, (String)"Cannot obtain reference to project");
    }
}

