/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.form.qoseditor.internal;

import eu.qimpress.samm.qosannotation.Annotation;
import eu.qimpress.samm.qosannotation.QosannotationPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class QoSAnnotationCache {
    private static final EStructuralFeature[] EMPTY_FEATURE_LIST = new EStructuralFeature[0];
    private static QoSAnnotationCache INSTANCE;
    private List<EClass> annotationList = new ArrayList<EClass>();
    private Map<EClass, List<EStructuralFeature>> annotationFeaturesMap = new HashMap<EClass, List<EStructuralFeature>>();
    private List<EStructuralFeature> annotationsFeaturesList = new ArrayList<EStructuralFeature>();
    private EStructuralFeature[] ignoredFeatures;

    public static QoSAnnotationCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new QoSAnnotationCache();
        }
        return INSTANCE;
    }

    private QoSAnnotationCache() {
        this.initialize();
    }

    public void initialize() {
        this.initIgnoredFeatures();
        this.initAnnotationList();
    }

    private void initIgnoredFeatures() {
        this.ignoredFeatures = (EStructuralFeature[])QosannotationPackage.eINSTANCE.getAnnotation().getEAllStructuralFeatures().toArray((Object[])new EStructuralFeature[0]);
    }

    private void initAnnotationList() {
        this.annotationList.clear();
        IConfigurationElement[] annotations = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.qimpress.samm.qosannotations");
        int i = 0;
        while (i < annotations.length) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(annotations[i].getAttribute("uri"));
            EClassifier classifier = ePackage.getEClassifier(annotations[i].getAttribute("class"));
            if (classifier != null && Annotation.class.isAssignableFrom(classifier.getInstanceClass()) && !classifier.getInstanceClass().equals(Annotation.class)) {
                EClass annotationType = (EClass)classifier;
                this.annotationList.add(annotationType);
                List<EStructuralFeature> structuralFeatures = this.collectStructuralFeatures(annotationType);
                this.annotationFeaturesMap.put(annotationType, structuralFeatures);
                this.annotationsFeaturesList.addAll(structuralFeatures);
            }
            ++i;
        }
    }

    private List<EStructuralFeature> collectStructuralFeatures(EClass annotationType) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>(4);
        for (EStructuralFeature esf : annotationType.getEAllStructuralFeatures()) {
            if (!esf.isChangeable() || esf.isMany() || this.isIgnoredFeature(esf)) continue;
            result.add(esf);
        }
        return result;
    }

    private boolean isIgnoredFeature(EStructuralFeature esf) {
        EStructuralFeature[] eStructuralFeatureArray = this.ignoredFeatures;
        int n = this.ignoredFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature iEsf = eStructuralFeatureArray[n2];
            if (iEsf.equals(esf)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public EClass[] getDefinedAnnotationTypes() {
        return this.annotationList.toArray(new EClass[this.annotationList.size()]);
    }

    public EStructuralFeature[] getAllAnnotationsFeatures() {
        return this.annotationsFeaturesList.toArray(new EStructuralFeature[this.annotationsFeaturesList.size()]);
    }

    public EStructuralFeature[] getAnnotationFeatures(EClass eClazz) {
        if (this.annotationFeaturesMap.containsKey(eClazz)) {
            List<EStructuralFeature> features = this.annotationFeaturesMap.get(eClazz);
            return features.toArray(new EStructuralFeature[features.size()]);
        }
        return EMPTY_FEATURE_LIST;
    }
}

