/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.form.qoseditor;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.editors.form.qoseditor.internal.QoSAnnotationCache;
import eu.qimpress.samm.qosannotation.Annotation;
import eu.qimpress.samm.qosannotation.QosAnnotations;
import eu.qimpress.samm.qosannotation.QosannotationFactory;
import eu.qimpress.samm.qosannotation.util.QosannotationAdapterFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class QoSEditorUtils {
    private static final Annotation[] EMPTY_ANNOTATION_LIST = new Annotation[0];
    private static final Logger logger = Logger.getLogger(QoSEditorUtils.class);

    public static EClass[] getDefinedAnnotationsTypes() {
        return QoSAnnotationCache.getInstance().getDefinedAnnotationTypes();
    }

    public static boolean containsAttributeForType(EClass annotationType, Class classToBeAnnotated) {
        EStructuralFeature[] eStructuralFeatureArray = QoSAnnotationCache.getInstance().getAnnotationFeatures(annotationType);
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature esf = eStructuralFeatureArray[n2];
            if (esf.isChangeable() && !esf.isMany() && esf.getEType().getInstanceClass().isAssignableFrom(classToBeAnnotated)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("EClass [" + annotationType.getName() + "] contains attribute [" + esf.getName() + "] of type :" + classToBeAnnotated));
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Object[] getAnnotatableEntitiesByAnnotation(IQProject project, EClass annotationType) {
        ArrayList<EObject> AnnotatableEntities = new ArrayList<EObject>();
        try {
            IQModel[] models;
            IQModel[] iQModelArray = models = project.getRepository().getDefaultAlternative().getModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IQModel model = iQModelArray[n2];
                Resource emfResource = model.getTopLevelEObject().eResource();
                TreeIterator modelEntitiesIterator = emfResource.getAllContents();
                EObject modelEntity = null;
                while (modelEntitiesIterator.hasNext()) {
                    modelEntity = (EObject)modelEntitiesIterator.next();
                    if (!QoSEditorUtils.containsAttributeForType(annotationType, modelEntity.getClass())) continue;
                    AnnotatableEntities.add(modelEntity);
                }
                ++n2;
            }
        }
        catch (RepositoryException repositoryException) {
            System.err.println("Uncastched Repository exception. Can not get project repository");
        }
        return AnnotatableEntities.toArray(new Object[AnnotatableEntities.size()]);
    }

    public static EClass[] getAnnotationTypesForType(Class clazz) {
        EClass[] annotations = QoSEditorUtils.getDefinedAnnotationsTypes();
        ArrayList<EClass> result = new ArrayList<EClass>();
        EClass[] eClassArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            EClass annotation = eClassArray[n2];
            if (QoSEditorUtils.containsAttributeForType(annotation, clazz)) {
                result.add(annotation);
            }
            ++n2;
        }
        return result.toArray(new EClass[result.size()]);
    }

    public static Annotation[] getAttachedAnnotations(EObject eo) throws RepositoryException {
        IProject project = QImpressCore.getProject((URI)eo.eResource().getURI());
        if (project == null) {
            return EMPTY_ANNOTATION_LIST;
        }
        Annotation[] definedAnnotations = QoSEditorUtils.getAccessibleAnnotations(project);
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Annotation[] annotationArray = definedAnnotations;
        int n = definedAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature[] eSFeatures;
            Annotation annotation = annotationArray[n2];
            EStructuralFeature[] eStructuralFeatureArray = eSFeatures = QoSAnnotationCache.getInstance().getAnnotationFeatures(annotation.eClass());
            int n3 = eSFeatures.length;
            int n4 = 0;
            while (n4 < n3) {
                EStructuralFeature esf = eStructuralFeatureArray[n4];
                Object value = annotation.eGet(esf);
                if (value instanceof EObject && EcoreUtil.getURI((EObject)((EObject)value)).equals((Object)EcoreUtil.getURI((EObject)eo))) {
                    result.add(annotation);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new Annotation[result.size()]);
    }

    public static QosAnnotations[] getAnnotationRepositories(IProject project) {
        return null;
    }

    public static Annotation[] getAccessibleAnnotationsForType(IProject project, Class clazz) throws RepositoryException {
        Annotation[] annotations = QoSEditorUtils.getAccessibleAnnotations(project);
        EClass[] annotationTypes = QoSEditorUtils.getAnnotationTypesForType(clazz);
        ArrayList<Annotation> result = new ArrayList<Annotation>(4);
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            EClass[] eClassArray = annotationTypes;
            int n3 = annotationTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                EClass annotationType = eClassArray[n4];
                if (annotation.eClass().equals(annotationType)) {
                    result.add(annotation);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new Annotation[result.size()]);
    }

    public static Annotation[] getAccessibleAnnotations(IProject project) throws RepositoryException {
        IQProject qProject = QImpressCore.getQProject((IProject)project);
        if (qProject == null) {
            return EMPTY_ANNOTATION_LIST;
        }
        IQModel model = qProject.getRepository().getDefaultAlternative().getModel("samm_qosannotation");
        QosAnnotations annotations = (QosAnnotations)model.getTopLevelEObject(QosAnnotations.class, QosannotationFactory.eINSTANCE.getQosannotationPackage().getQosAnnotations());
        return (Annotation[])annotations.getAnnotation().toArray((Object[])new Annotation[annotations.getAnnotation().size()]);
    }

    protected static Annotation[] getQModelAnnotations(IQModel qModel) {
        QosAnnotations annotations = (QosAnnotations)qModel.getTopLevelEObject(QosAnnotations.class, QosannotationFactory.eINSTANCE.getQosannotationPackage().getQosAnnotations());
        return (Annotation[])annotations.getAnnotation().toArray((Object[])new Annotation[annotations.getAnnotation().size()]);
    }

    public static EStructuralFeature getStructuralFeatureForType(EClass eClazz, Class clazz) {
        EStructuralFeature[] features;
        EStructuralFeature[] eStructuralFeatureArray = features = QoSAnnotationCache.getInstance().getAnnotationFeatures(eClazz);
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature esf = eStructuralFeatureArray[n2];
            if (esf.isChangeable() && !esf.isMany() && esf.getEType().getInstanceClass().isAssignableFrom(clazz)) {
                return esf;
            }
            ++n2;
        }
        return null;
    }

    public static boolean setAnnotationReference(Annotation annotation, EObject referencedObject) {
        EStructuralFeature esf = QoSEditorUtils.getStructuralFeatureForType(annotation.eClass(), referencedObject.getClass());
        if (esf != null) {
            annotation.eSet(esf, (Object)referencedObject);
            return true;
        }
        return false;
    }

    public static final EClass browseForAnnotationType(Shell shell, EClass[] eclasses, String initialPattern) {
        ElementListSelectionDialog dialog = QoSEditorUtils.getSelectionDialog(shell, eclasses, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory()), initialPattern);
        dialog.setTitle("Create new annotation in default alternative");
        dialog.setMessage("Select annotation type");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            EClass type = (EClass)dialog.getResult()[0];
            return type;
        }
        return null;
    }

    public static final Annotation browseForAnnotationInstance(Shell shell, Annotation[] annotations, String initialPattern) {
        ElementListSelectionDialog dialog = QoSEditorUtils.getSelectionDialog(shell, annotations, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new QosannotationAdapterFactory()), initialPattern);
        dialog.setTitle("Attach existing annotation to the element");
        dialog.setMessage("Select annotation instance");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Annotation annotation = (Annotation)dialog.getResult()[0];
            return annotation;
        }
        return null;
    }

    protected static ElementListSelectionDialog getSelectionDialog(Shell shell, Object[] objects, ILabelProvider renderer, String filter) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, renderer);
        dialog.setAllowDuplicates(false);
        dialog.setElements(objects);
        dialog.setFilter(filter);
        dialog.setSize(120, 18);
        return dialog;
    }

    public static Annotation addNewAnnotation(IProject project, EClass eClazz) throws RepositoryException {
        IQModel model = QImpressCore.getQProject((IProject)project).getRepository().getDefaultAlternative().getModel("samm_qosannotation");
        Annotation annotation = null;
        if (model != null) {
            QosAnnotations annotations = (QosAnnotations)model.getTopLevelEObject(QosAnnotations.class, QosannotationFactory.eINSTANCE.getQosannotationPackage().getQosAnnotations());
            assert (annotations != null);
            EPackage ePackage = eClazz.getEPackage();
            annotation = (Annotation)ePackage.getEFactoryInstance().create(eClazz);
            annotations.getAnnotation().add((Object)annotation);
        }
        return annotation;
    }

    public static Annotation addNewAnnotationInstance(IProject project, Annotation annotationInstance) throws RepositoryException {
        IQModel model = QImpressCore.getQProject((IProject)project).getRepository().getDefaultAlternative().getModel("samm_qosannotation");
        if (model != null) {
            QosAnnotations annotations = (QosAnnotations)model.getTopLevelEObject(QosAnnotations.class, QosannotationFactory.eINSTANCE.getQosannotationPackage().getQosAnnotations());
            assert (annotations != null);
            annotations.getAnnotation().add((Object)annotationInstance);
        }
        return annotationInstance;
    }

    public static Map<EClass, Annotation> createPrototypeInstances(EClass[] annotationTypes) {
        HashMap<EClass, Annotation> result = new HashMap<EClass, Annotation>();
        EClass[] eClassArray = annotationTypes;
        int n = annotationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            EPackage ePackage = eClass.getEPackage();
            Annotation annotation = (Annotation)ePackage.getEFactoryInstance().create(eClass);
            result.put(eClass, annotation);
            ++n2;
        }
        return result;
    }

    public static void getAnnotationLabel(Annotation annotation, StringBuilder sb) {
        sb.setLength(0);
        sb.append(annotation.getName());
        sb.append(" (");
        sb.append(annotation.eClass().getName());
        sb.append(')');
    }
}

