/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.io.xml;

import com.generationjava.io.WritingException;
import com.generationjava.io.xml.XmlWritingException;
import com.generationjava.web.XmlW;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;

public class XmlWriter {
    private Writer writer;
    private Stack stack;
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed;

    public XmlWriter writeEntity(String string) throws WritingException {
        try {
            this.closeOpeningTag();
            this.closed = false;
            this.writer.write("<");
            this.writer.write(string);
            this.stack.add(string);
            this.empty = true;
            return this;
        }
        catch (IOException iOException) {
            throw new XmlWritingException(iOException);
        }
    }

    private void closeOpeningTag() throws IOException {
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.writer.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        if (this.attrs != null) {
            this.writer.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    public XmlWriter writeAttribute(String string, String string2) throws WritingException {
        if (this.attrs == null) {
            this.attrs = new StringBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(string);
        this.attrs.append("=\"");
        this.attrs.append(XmlW.escapeXml(string2));
        this.attrs.append("\"");
        return this;
    }

    public XmlWriter endEntity() throws WritingException {
        try {
            if (this.stack.empty()) {
                throw new XmlWritingException("Called endEntity too many times. ");
            }
            String string = (String)this.stack.pop();
            if (string != null) {
                if (this.empty) {
                    this.writeAttributes();
                    this.writer.write("/>");
                } else {
                    this.writer.write("</");
                    this.writer.write(string);
                    this.writer.write(">");
                }
                this.empty = false;
                this.closed = true;
            }
            return this;
        }
        catch (IOException iOException) {
            throw new XmlWritingException(iOException);
        }
    }

    public void close() throws WritingException {
        if (!this.stack.empty()) {
            throw new XmlWritingException("Tags are not all closed. Possibly, " + this.stack.pop() + " is unclosed. ");
        }
    }

    public XmlWriter writeText(String string) throws WritingException {
        try {
            this.closeOpeningTag();
            this.empty = false;
            this.writer.write(XmlW.escapeXml(string));
            return this;
        }
        catch (IOException iOException) {
            throw new XmlWritingException(iOException);
        }
    }

    public static void main(String[] stringArray) throws WritingException {
        XmlWriter.test1();
        XmlWriter.test2();
    }

    public static void test1() throws WritingException {
        StringWriter stringWriter = new StringWriter();
        XmlWriter xmlWriter = new XmlWriter(stringWriter);
        xmlWriter.writeEntity("person").writeAttribute("name", "fred").writeAttribute("age", "12").writeEntity("phone").writeText("4254343").endEntity().writeEntity("bob").endEntity().endEntity();
        xmlWriter.close();
        System.err.println(((Object)stringWriter).toString());
    }

    public static void test2() throws WritingException {
        StringWriter stringWriter = new StringWriter();
        XmlWriter xmlWriter = new XmlWriter(stringWriter);
        xmlWriter.writeEntity("person");
        xmlWriter.writeAttribute("name", "fred");
        xmlWriter.writeAttribute("age", "12");
        xmlWriter.writeEntity("phone");
        xmlWriter.writeText("4254343");
        xmlWriter.endEntity();
        xmlWriter.writeEntity("bob");
        xmlWriter.endEntity();
        xmlWriter.endEntity();
        xmlWriter.close();
        System.err.println(((Object)stringWriter).toString());
    }

    public XmlWriter(Writer writer) {
        this.writer = writer;
        this.closed = true;
        this.stack = new Stack();
    }
}

