/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.storage.lists;

import de.uka.ipd.sdq.sensorframework.storage.lists.ISerialiser;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Chunk<T> {
    private long myFilePos;
    private T[] data = null;
    private int nextFreeElement = 0;
    private RandomAccessFile raf;
    private ISerialiser<T> serialiser;
    private boolean changed;
    private long fromElement;

    public Chunk(RandomAccessFile raf, ISerialiser<T> serialiser) throws IOException {
        this.myFilePos = raf.length();
        this.raf = raf;
        this.serialiser = serialiser;
        this.data = new Object[10000];
        this.changed = false;
        this.fromElement = this.myFilePos / serialiser.getElementLength();
    }

    public Chunk(RandomAccessFile raf, ISerialiser<T> serialiser, int chunkNo) throws IOException {
        this.raf = raf;
        this.serialiser = serialiser;
        raf.seek((long)(chunkNo * 10000) * serialiser.getElementLength());
        this.myFilePos = raf.getFilePointer();
        this.loadChunk();
        this.changed = false;
        this.fromElement = this.myFilePos / serialiser.getElementLength();
    }

    public void add(T d) {
        if (d == null) {
            throw new IllegalArgumentException("Background memory list does not support null values.");
        }
        this.data[this.nextFreeElement++] = d;
        this.changed = true;
    }

    public long fromElement() {
        return this.fromElement;
    }

    public T get(int index) {
        return this.data[index];
    }

    public boolean isFull() {
        return this.nextFreeElement >= this.data.length;
    }

    private void loadChunk() throws IOException {
        int count = (int)(10000L * this.serialiser.getElementLength());
        if (this.raf.length() < this.raf.getFilePointer() + (long)count) {
            count = (int)(this.raf.length() - this.raf.getFilePointer());
        }
        byte[] b = new byte[count];
        this.raf.read(b, 0, count);
        T[] newData = this.serialiser.deserialise(b);
        if (newData.length == 10000) {
            this.data = newData;
        } else {
            this.data = new Object[10000];
            int i = 0;
            while (i < newData.length) {
                this.data[i] = newData[i];
                ++i;
            }
        }
        this.nextFreeElement = newData.length;
    }

    public void persist() throws IOException {
        if (this.changed) {
            this.raf.seek(this.myFilePos);
            this.raf.write(this.serialiser.serialise(this.data, this.nextFreeElement));
        }
    }

    public int size() {
        return this.nextFreeElement;
    }

    public long toElement() {
        return this.fromElement() + (long)this.nextFreeElement - 1L;
    }

    public boolean accepts(int index) {
        if (this.fromElement <= (long)index) {
            if (this.toElement() > (long)index) {
                return true;
            }
            if ((long)this.nextFreeElement + this.fromElement == (long)index) {
                return !this.isFull();
            }
            return false;
        }
        return false;
    }
}

