/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.repository.diagram.custom.edit.parts;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.contributions.AbstractOpenDiagramAction;
import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.GMFUtils;
import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.LogFactory;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.OperationBehaviourEditPart;
import eu.qimpress.ide.editors.gmf.seff.helper.OpenSeffDiagramAction;
import eu.qimpress.ide.editors.gmf.seff.helper.SeffUtils;
import eu.qimpress.samm.behaviour.OperationBehaviour;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.seff.ResourceDemandingSEFF;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CustomOperationBehaviourEditPart
extends OperationBehaviourEditPart {
    Logger log = LogFactory.getLog(CustomOperationBehaviourEditPart.class);

    public CustomOperationBehaviourEditPart(View view) {
        super(view);
    }

    protected String getLabelText() {
        StringBuilder text = new StringBuilder();
        EObject parserElement = this.getParserElement();
        if (parserElement instanceof OperationBehaviour) {
            OperationBehaviour opBehaviour = (OperationBehaviour)parserElement;
            text.append(String.valueOf(opBehaviour.eClass().getName()) + " <");
            Operation operation = opBehaviour.getOperation();
            if (operation != null) {
                Interface parentInterface = (Interface)operation.eContainer();
                text.append(parentInterface.getName() != null ? String.valueOf(parentInterface.getName()) + "." : "");
                text.append(operation.getName() != null ? operation.getName() : "");
            }
            text.append(">");
        }
        if (text.length() == 0) {
            return super.getLabelText();
        }
        return text.toString();
    }

    public void performRequest(Request request) {
        if ("open" == request.getType()) {
            if (!(((View)this.getModel()).getElement() instanceof SeffBehaviourStub)) {
                return;
            }
            SeffBehaviourStub stub = (SeffBehaviourStub)((View)this.getModel()).getElement();
            ResourceDemandingSEFF seff = SeffUtils.findReferencingSeff((OperationBehaviour)stub);
            if (seff == null) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Model integrity problem", (String)"Could not locate a Seff Behaviour in the Seff models related to the selected Behaviour Stub\n\nNo diagram will be opened");
                return;
            }
            GMFUtils.createAndOpenDiagram((EObject)seff, (AbstractOpenDiagramAction)new OpenSeffDiagramAction(seff));
        } else {
            super.performRequest(request);
        }
    }
}

