/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.wizards;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.operations.CreateQAlternativeUIOperation;
import eu.qimpress.ide.backbone.core.ui.wizards.NewQAlternativePage;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewQAlternativeWizard
extends Wizard
implements INewWizard {
    public static final Logger logger = Logger.getLogger(NewQAlternativeWizard.class);
    public static final String WIZARD_ID = "eu.qimpress.ide.backbone.core.ui.NewAlternativeWizardID";
    private NewQAlternativePage page;
    private IStructuredSelection initialSelection;

    public NewQAlternativeWizard() {
        this.setWindowTitle("New alternative");
        this.setNeedsProgressMonitor(false);
    }

    public boolean performFinish() {
        String alternativeName = this.page.getAlternativeName();
        Object alternativeParent = this.page.getAlternativeParentSelection().getFirstElement();
        try {
            CreateQAlternativeUIOperation operation = new CreateQAlternativeUIOperation(alternativeName, alternativeParent);
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error occured", (String)("Cannot create new alternative because of " + e.getMessage()));
            logger.error((Object)"Alternative creation failed", (Throwable)e);
        }
        return true;
    }

    public void addPages() {
        IQElement parentElement = null;
        if (this.initialSelection.size() == 1 && (this.initialSelection.getFirstElement() instanceof IQAlternative || this.initialSelection.getFirstElement() instanceof IQRepository)) {
            parentElement = (IQElement)this.initialSelection.getFirstElement();
        }
        this.page = new NewQAlternativePage(parentElement);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
    }
}

