/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorLabelProvider;
import eu.qimpress.ide.backbone.core.ui.internal.ChainedLabelProvider;
import eu.qimpress.ide.backbone.core.ui.widgets.AbstractWidgetFactory;
import eu.qimpress.ide.backbone.core.utils.SAMMModelsUtils;
import eu.qimpress.samm.usagemodel.UsageModel;
import eu.qimpress.samm.usagemodel.provider.UsagemodelItemProviderAdapterFactory;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class UsageModelViewerFactory
extends AbstractWidgetFactory<CheckboxTreeViewer> {
    private static final int TREE_DEFAULT_STYLE = 268438276;
    private static final String[] NO_USAGE_MODEL_WARNING = new String[]{"<no usage model>"};

    protected UsageModelViewerFactory(CheckboxTreeViewer widget) {
        super(widget);
    }

    public static UsageModelViewerFactory createWidgetFactory(Composite parent) {
        UsageModelViewerFactory factory = UsageModelViewerFactory.createWidgetFactory(parent, 268438276, UsageModelViewerFactory.class, CheckboxTreeViewer.class);
        return factory;
    }

    public static void applyFilterFor(final IQAlternative alternative, CheckboxTreeViewer treeViewer) {
        treeViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IQProject) {
                    if (((IQProject)element).equals(alternative.getRepository().getQProject())) {
                        return true;
                    }
                } else if (element instanceof IQAlternative) {
                    if (((IQAlternative)element).equals(alternative)) {
                        return true;
                    }
                } else {
                    if (element instanceof UsageModel) {
                        return true;
                    }
                    if (element instanceof String) {
                        return true;
                    }
                }
                return false;
            }
        }});
    }

    public static void setModelLookup(SAMMModelsUtils.EnumModelLookup lookup, CheckboxTreeViewer treeViewer) {
        IContentProvider provider = treeViewer.getContentProvider();
        if (provider instanceof UsageModelNavigatorContentProvider) {
            ((UsageModelNavigatorContentProvider)provider).setModelLookup(lookup);
        }
    }

    public static SAMMModelsUtils.EnumModelLookup getModelLookup(CheckboxTreeViewer treeViewer) {
        IContentProvider provider = treeViewer.getContentProvider();
        if (provider instanceof UsageModelNavigatorContentProvider) {
            return ((UsageModelNavigatorContentProvider)provider).getModelLookup();
        }
        return SAMMModelsUtils.EnumModelLookup.ONLY_LOCAL;
    }

    public static void setFlatViewMode(boolean flatMode, CheckboxTreeViewer treeViewer) {
        IContentProvider provider = treeViewer.getContentProvider();
        if (provider instanceof UsageModelNavigatorContentProvider) {
            ((UsageModelNavigatorContentProvider)provider).setFlatViewMode(flatMode);
        }
    }

    @Override
    protected void configureWidget() {
        ((CheckboxTreeViewer)this.widget).setContentProvider((IContentProvider)new UsageModelNavigatorContentProvider());
        ((CheckboxTreeViewer)this.widget).setLabelProvider((IBaseLabelProvider)new ChainedLabelProvider((ILabelProvider)new QAppNavigatorLabelProvider(), new ChainedLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new UsagemodelItemProviderAdapterFactory()))));
        ((CheckboxTreeViewer)this.widget).setInput(null);
    }

    @Override
    protected void finalizeWidget() {
        ((CheckboxTreeViewer)this.widget).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof UsageModel) {
                    if (!event.getChecked()) {
                        ((CheckboxTreeViewer)UsageModelViewerFactory.this.widget).setCheckedElements(new Object[0]);
                    } else {
                        ((CheckboxTreeViewer)UsageModelViewerFactory.this.widget).setCheckedElements(new Object[]{event.getElement()});
                    }
                } else {
                    ((CheckboxTreeViewer)UsageModelViewerFactory.this.widget).setChecked(element, false);
                }
            }
        });
    }

    public UsageModelViewerFactory setupModelLookupMode(SAMMModelsUtils.EnumModelLookup lookup) {
        ((UsageModelNavigatorContentProvider)((CheckboxTreeViewer)this.widget).getContentProvider()).setModelLookup(lookup);
        return this;
    }

    public static class UsageModelNavigatorContentProvider
    extends WorkbenchContentProvider {
        private static final Object[] NO_CHILDREN = new Object[0];
        private static final Logger logger = Logger.getLogger(UsageModelNavigatorContentProvider.class);
        private SAMMModelsUtils.EnumModelLookup modelLookup = SAMMModelsUtils.EnumModelLookup.ONLY_LOCAL;
        private boolean flatViewMode = true;
        private boolean showNoUsageModelWarning = true;

        public Object[] getChildren(Object element) {
            try {
                if (element instanceof IQProject) {
                    return ((IQProject)element).getRepository().listAllAlternatives();
                }
                if (element instanceof IQAlternative) {
                    Object[] models = SAMMModelsUtils.getUsageModels((IQAlternative)((IQAlternative)element), (SAMMModelsUtils.EnumModelLookup)this.modelLookup);
                    if (models.length == 0 && this.showNoUsageModelWarning) {
                        return NO_USAGE_MODEL_WARNING;
                    }
                    return models;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Cannot get children for " + element), (Throwable)e);
            }
            return super.getChildren(element);
        }

        public Object[] getElements(Object element) {
            if (element instanceof IQApplicationModel) {
                IQApplicationModel qAppModel = (IQApplicationModel)element;
                return qAppModel.getQProjects();
            }
            if (element instanceof IQAlternative) {
                if (this.flatViewMode) {
                    return this.getChildren(element);
                }
                return new Object[]{((IQAlternative)element).getRepository().getQProject()};
            }
            if (element == null) {
                return NO_CHILDREN;
            }
            return super.getElements(element);
        }

        public void setModelLookup(SAMMModelsUtils.EnumModelLookup modelLookup) {
            this.modelLookup = modelLookup;
        }

        public SAMMModelsUtils.EnumModelLookup getModelLookup() {
            return this.modelLookup;
        }

        public void setFlatViewMode(boolean flatMode) {
            this.flatViewMode = flatMode;
        }
    }
}

