/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.tabs;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.tabs.IAlternativeSelection;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativeEvaluationSelectorWidgetFactory;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesCheckBoxTreeViewer;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QImpressAlternativeEvaluationSelectionTab
extends AbstractLaunchConfigurationTab
implements IAlternativeSelection {
    public static final String SELECTED_ALTERNATIVE_EVALUATION_ID = "eu.qimpress.ide.backbone.core.ui.AlternativeEvaluationSelection.id";
    public static final String SELECTED_PROJECT_NAME = "eu.qimpress.ide.backbone.core.ui.AlternativeEvaluationSelection.project";
    private static final Logger logger = Logger.getLogger(AbstractLaunchConfigurationTab.class);
    private CheckboxTreeViewer alternativeEvaluationViewer;
    private Label selectionText;
    private IQAlternative selectedAlternative;

    public void createControl(Composite parent) {
        Composite myTabControl = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        myTabControl.setLayout((Layout)gridLayout);
        this.setControl((Control)myTabControl);
        Group grpSelectQimpressAlternative = new Group(myTabControl, 4);
        grpSelectQimpressAlternative.setText("Select Alternative Evaluation");
        GridLayout selectorLayout = new GridLayout();
        selectorLayout.marginWidth = 5;
        selectorLayout.marginHeight = 5;
        selectorLayout.verticalSpacing = 0;
        selectorLayout.numColumns = 1;
        grpSelectQimpressAlternative.setLayout((Layout)selectorLayout);
        grpSelectQimpressAlternative.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.alternativeEvaluationViewer = (CheckboxTreeViewer)QAlternativeEvaluationSelectorWidgetFactory.createWidgetFactory((Composite)grpSelectQimpressAlternative).getWidget();
        this.alternativeEvaluationViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.alternativeEvaluationViewer.expandAll();
        this.alternativeEvaluationViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                QImpressAlternativeEvaluationSelectionTab.this.setDirty(true);
                QImpressAlternativeEvaluationSelectionTab.this.updateLaunchConfigurationDialog();
                QImpressAlternativeEvaluationSelectionTab.this.updateCheckedItemLabelText();
            }
        });
        final Button filterSelectionButton = new Button((Composite)grpSelectQimpressAlternative, 0x800002);
        filterSelectionButton.setText("Show all");
        filterSelectionButton.setLayoutData((Object)new GridData(131072, 1024, false, false, 1, 1));
        filterSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QImpressAlternativeEvaluationSelectionTab.this.enableFiltering(!filterSelectionButton.getSelection());
            }
        });
        Label selection = new Label(myTabControl, 0);
        selection.setText("Selected Alternative Evaluation: ");
        selection.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.selectionText = new Label(myTabControl, 0);
        this.selectionText.setText("<none>");
        this.selectionText.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.createNewAlternativeEvaluationButton(myTabControl);
        this.createDeleteSelectedAlternativeEvaluationButton(myTabControl);
    }

    private void createNewAlternativeEvaluationButton(Composite parent) {
        Button createButton = new Button(parent, 8);
        createButton.setText("Create Alternative Evaluation");
        createButton.addListener(13, new Listener(){
            private QAlternativesCheckBoxTreeViewer treeViewer;
            private Text evalNameInputField;

            private void updateInputFieldBehaviour() {
                if (!$assertionsDisabled && this.evalNameInputField == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.treeViewer == null) {
                    throw new AssertionError();
                }
                this.evalNameInputField.setEnabled(this.treeViewer.getFirstSelectedAlternative() != null);
            }

            public void handleEvent(Event event) {
                final Shell dialog = new Shell(67680);
                dialog.setText("Select Alternative");
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginWidth = 5;
                gridLayout.marginHeight = 5;
                dialog.setLayout((Layout)gridLayout);
                Group inputFieldGroup = new Group((Composite)dialog, 32);
                inputFieldGroup.setLayoutData((Object)new GridData(4, 4, true, false));
                inputFieldGroup.setText("Name of an alternative evaluation:");
                inputFieldGroup.setLayout((Layout)new GridLayout(3, false));
                this.evalNameInputField = new Text((Composite)inputFieldGroup, 2052);
                this.evalNameInputField.setLayoutData((Object)new GridData(4, 4, true, true));
                final Button addButton = new Button((Composite)inputFieldGroup, 8);
                addButton.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
                addButton.setText("Add");
                final Button closeButton = new Button((Composite)inputFieldGroup, 8);
                closeButton.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
                closeButton.setText("Close");
                this.treeViewer = (QAlternativesCheckBoxTreeViewer)QAlternativesTreeViewerFactory.createTreeViewer((Composite)dialog, QAlternativesTreeViewerFactory.SelectAlternativesEnum.SELECT_ONE).setCanSelectQRepository(false).getTreeViewer();
                this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
                this.treeViewer.expandAll();
                this.treeViewer.addCheckStateListener(new ICheckStateListener(){

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        this.updateInputFieldBehaviour();
                        evalNameInputField.forceFocus();
                        evalNameInputField.selectAll();
                    }
                });
                this.updateInputFieldBehaviour();
                this.evalNameInputField.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\n' || e.character == '\r') {
                            addButton.notifyListeners(13, new Event());
                        } else if (e.character == '\u001b') {
                            closeButton.notifyListeners(13, new Event());
                        }
                    }
                });
                addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IQAlternative selectedAlternative = treeViewer.getFirstSelectedAlternative();
                        if (!$assertionsDisabled && selectedAlternative == null) {
                            throw new AssertionError();
                        }
                        try {
                            IQRepository repo = selectedAlternative.getRepository();
                            AlternativeEvaluation newAlternativeEvaluation = repo.createAlternativeEvaluation();
                            newAlternativeEvaluation.setName(evalNameInputField.getText());
                            newAlternativeEvaluation.setAlternativeId(selectedAlternative.getInfo().getId());
                            IQModel model = QImpressCore.getResultModelByEObject((EObject)newAlternativeEvaluation);
                            QImpressAlternativeEvaluationSelectionTab.this.saveDirtyModel(model);
                            QImpressAlternativeEvaluationSelectionTab.this.alternativeEvaluationViewer.refresh();
                            QImpressAlternativeEvaluationSelectionTab.this.alternativeEvaluationViewer.expandAll();
                            evalNameInputField.forceFocus();
                            evalNameInputField.selectAll();
                        }
                        catch (RepositoryException e1) {
                            logger.warn((Object)e1);
                        }
                    }
                });
                closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        dialog.dispose();
                    }
                });
                dialog.setSize(300, 500);
                Point cursorLoc = event.display.getCursorLocation();
                cursorLoc.x -= dialog.getSize().x / 2;
                cursorLoc.y -= dialog.getSize().y / 2;
                dialog.setLocation(cursorLoc);
                dialog.open();
            }
        });
    }

    private void saveDirtyModel(IQModel model) {
        try {
            model.save();
        }
        catch (RepositoryException e) {
            logger.error((Object)("Model " + model.getName() + " cannot be saved. Exception occured."), (Throwable)e);
        }
    }

    private void createDeleteSelectedAlternativeEvaluationButton(Composite parent) {
        Button deleteButton = new Button(parent, 8);
        deleteButton.setText("Delete Alternative Evaluation");
        deleteButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Object[] objectArray = QImpressAlternativeEvaluationSelectionTab.this.alternativeEvaluationViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof AlternativeEvaluation) {
                        AlternativeEvaluation alternativeEvaluation = (AlternativeEvaluation)element;
                        IQProject qproject = QImpressCore.getQProject((EObject)alternativeEvaluation);
                        try {
                            IQModel model = QImpressCore.getResultModelByEObject((EObject)alternativeEvaluation);
                            qproject.getRepository().deleteAlternativeEvaluation(alternativeEvaluation);
                            QImpressAlternativeEvaluationSelectionTab.this.saveDirtyModel(model);
                        }
                        catch (RepositoryException e) {
                            logger.warn((Object)e);
                        }
                    }
                    ++n2;
                }
                QImpressAlternativeEvaluationSelectionTab.this.alternativeEvaluationViewer.refresh();
            }
        });
    }

    private void updateCheckedItemLabelText() {
        Object[] checked = this.alternativeEvaluationViewer.getCheckedElements();
        if (checked.length > 0 && checked[0] instanceof AlternativeEvaluation) {
            AlternativeEvaluation alternativeEvaluation = (AlternativeEvaluation)checked[0];
            String alternativeEvaluationName = alternativeEvaluation.getName();
            String alternativeDescription = "<unknown alternative>";
            String alternativeId = alternativeEvaluation.getAlternativeId();
            try {
                IQAlternative alternative = QImpressCore.getQProject((EObject)alternativeEvaluation).getRepository().getAlternative(alternativeId);
                alternativeDescription = "'" + alternative.getInfo().getDescription() + "'";
            }
            catch (Exception exception) {}
            this.selectionText.setText("'" + alternativeEvaluationName + "' in " + alternativeDescription);
        } else {
            this.selectionText.setText("<none>");
        }
    }

    public String getName() {
        return "Q-ImPrESS Alternative Evaluation";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        IQRepository repository;
        String cfgAlternativeEvaluationId = "";
        String cfgProjectName = "";
        try {
            cfgAlternativeEvaluationId = configuration.getAttribute(SELECTED_ALTERNATIVE_EVALUATION_ID, "");
            cfgProjectName = configuration.getAttribute(SELECTED_PROJECT_NAME, "");
        }
        catch (CoreException e) {
            logger.warn((Object)e);
        }
        if (cfgAlternativeEvaluationId.equals("") || cfgProjectName.equals("")) {
            return;
        }
        try {
            repository = QImpressCore.getQProject((String)cfgProjectName).getRepository();
            if (repository == null) {
                return;
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Could not get repository from the project name:" + cfgProjectName));
            return;
        }
        try {
            for (AlternativeEvaluation alteval : repository.getAllAlternativeEvaluations()) {
                if (!cfgAlternativeEvaluationId.equals(alteval.getId())) continue;
                this.alternativeEvaluationViewer.setChecked((Object)alteval, true);
                this.updateCheckedItemLabelText();
                return;
            }
        }
        catch (RepositoryException e) {
            logger.warn((Object)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Object[] elements = this.alternativeEvaluationViewer.getCheckedElements();
        if (elements.length != 1 || !(elements[0] instanceof AlternativeEvaluation)) {
            configuration.setAttribute(SELECTED_ALTERNATIVE_EVALUATION_ID, "");
        } else {
            AlternativeEvaluation selectedAlternativeEvaluation = (AlternativeEvaluation)elements[0];
            configuration.setAttribute(SELECTED_ALTERNATIVE_EVALUATION_ID, selectedAlternativeEvaluation.getId());
            String projectName = QImpressCore.getQProject((EObject)selectedAlternativeEvaluation).getProject().getName();
            configuration.setAttribute(SELECTED_PROJECT_NAME, projectName);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!super.isValid(launchConfig)) {
            return false;
        }
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        Object[] elements = this.alternativeEvaluationViewer.getCheckedElements();
        if (elements.length != 1) {
            return "Select a single alternative evaluation";
        }
        if (!(elements[0] instanceof AlternativeEvaluation)) {
            return "Selection is not an alternative evaluation";
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SELECTED_ALTERNATIVE_EVALUATION_ID, "");
        configuration.setAttribute(SELECTED_PROJECT_NAME, "");
    }

    @Override
    public void setSelectedAlternative(IQAlternative alternative) {
        this.selectedAlternative = alternative;
        this.enableFiltering(this.selectedAlternative != null);
        this.alternativeEvaluationViewer.expandAll();
        this.setDirty(true);
    }

    protected void enableFiltering(boolean enable) {
        if (enable && this.selectedAlternative != null) {
            QAlternativeEvaluationSelectorWidgetFactory.applyFilterFor(this.selectedAlternative, this.alternativeEvaluationViewer);
        } else {
            this.alternativeEvaluationViewer.resetFilters();
        }
    }
}

