/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.internal.filters;

import eu.qimpress.ide.backbone.core.ui.internal.filters.IQFilter;
import eu.qimpress.ide.backbone.core.ui.internal.filters.QFilter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class GenericHiddenContentFilter
extends ViewerFilter {
    public static final String QFILTERS_EXTENSION_POINT_ID = "eu.qimpress.ide.backbone.core.ui.filters";
    private IQFilter[] registeredFilters;

    public GenericHiddenContentFilter() {
        this.init();
    }

    protected void init() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(QFILTERS_EXTENSION_POINT_ID);
        this.registeredFilters = new IQFilter[configs.length];
        int i = 0;
        IConfigurationElement[] iConfigurationElementArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            this.registeredFilters[i++] = this.createFilter(config);
            ++n2;
        }
    }

    protected IQFilter createFilter(IConfigurationElement config) {
        QFilter filter = new QFilter(config.getAttribute("name"), config.getAttribute("pattern"), Boolean.getBoolean(config.getAttribute("global-scope")));
        return filter;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IQFilter[] iQFilterArray = this.registeredFilters;
        if (this.registeredFilters.length != 0) {
            IQFilter filter = iQFilterArray[0];
            return filter.select(parentElement, element);
        }
        return true;
    }
}

