/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dashboardgenerator;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLManager {
    public static Element createTable(List<List<String>> lines, List<List<String>> linklines) {
        Document document = DocumentHelper.createDocument();
        Element table = document.addElement("table");
        int currentindexLine = 0;
        for (List<String> line : lines) {
            Element htmlLine = table.addElement("tr");
            int currentindexColumn = 0;
            for (String c : line) {
                String text = c;
                if (text.equals("X") || currentindexLine == 0 || currentindexColumn == 0 || linklines == null) {
                    htmlLine.addElement("td").addText(text);
                } else {
                    htmlLine.addElement("td").addElement("a").addAttribute("href", linklines.get(currentindexLine).get(currentindexColumn)).addText(text);
                }
                ++currentindexColumn;
            }
            ++currentindexLine;
        }
        return table;
    }

    public static void writeHTML(String templatefile, String outputfile, List<List<String>> lines, List<List<String>> linklines, String text) {
        SAXReader reader = new SAXReader(false);
        try {
            FileInputStream in = null;
            try {
                in = new FileInputStream(templatefile);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            Document document = reader.read((InputStream)in);
            Element table = XMLManager.createTable(lines, linklines);
            Element root = document.getRootElement();
            Element body = root.element("body");
            body.addElement("h1").addText(text);
            body.add(table);
            XMLWriter writer = null;
            try {
                writer = new XMLWriter((Writer)new FileWriter(outputfile));
                writer.write(document);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public static Element setRootXML(Document document) {
        Element root = document.addElement("timestamplist");
        return root;
    }

    public static Element writeElementtoXML(Element parentElement, String id, String kindElement) {
        Element kElement = parentElement.addElement(kindElement);
        if (id != null) {
            kElement.addAttribute("ID", id);
        }
        return kElement;
    }

    public static void writeAttributetoXML(Element attriElement, String attriName, String attriValue) {
        attriElement.addAttribute(attriName, attriValue);
    }

    public static void writeDoctoXML(Document document, String outputfile) {
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((Writer)new FileWriter(outputfile));
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

