/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dashboardgenerator;

import de.fzi.sissy.dashboardgenerator.Activator;
import de.fzi.sissy.dashboardgenerator.DashboardGeneratorConfiguration;
import de.fzi.sissy.dashboardgenerator.XMLManager;
import de.fzi.sissy.persistence.JDBCWrapper;
import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.runtime.IProgressMonitor;

public class DashboardGeneratorJob
implements IJob {
    private DashboardGeneratorConfiguration configuration;

    public DashboardGeneratorJob(DashboardGeneratorConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.importInitFile();
        this.generateViewsAndImportDataFromDatabase();
        this.generateXmlAndImportDataFromDatabase();
    }

    public String getName() {
        return "Dashboard Generator";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    private void importInitFile() {
        JDBCWrapper jdbcWrapper = JDBCWrapper.createJDBCWrapper((DatabaseConfiguration)this.configuration.getDatabaseConfiguration());
        jdbcWrapper.getConnection();
        this.createViewProblemTimeNumOfInstances(jdbcWrapper);
        this.createViewProblemTime(jdbcWrapper);
    }

    private void generateViewsAndImportDataFromDatabase() {
        JDBCWrapper jdbcWrapper = JDBCWrapper.createJDBCWrapper((DatabaseConfiguration)this.configuration.getDatabaseConfiguration());
        jdbcWrapper.getConnection();
        List<String> kindofproblems = this.retrieveProblemIds(jdbcWrapper);
        List<String> analysistimestamps = this.retrieveAnalysisTimestamps(jdbcWrapper);
        ArrayList<List<String>> targetLines = new ArrayList<List<String>>();
        ArrayList<List<String>> targetLinks = new ArrayList<List<String>>();
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> linkofinstances = new ArrayList<String>();
        String resourceFolder = Activator.getDefault().getResourceFolderPath().getAbsolutePath();
        String resultFolder = this.configuration.getDashboardTargetDirectoryPath();
        lines.add("");
        linkofinstances.add("");
        for (String timestamp : analysistimestamps) {
            lines.add(timestamp);
            linkofinstances.add("");
        }
        targetLines.add(lines);
        targetLinks.add(linkofinstances);
        int problemcounter = 0;
        for (String problem : kindofproblems) {
            ++problemcounter;
            lines = new ArrayList();
            linkofinstances = new ArrayList();
            lines.add(problem);
            linkofinstances.add("");
            this.calculateAndSetNumberOfInstances(jdbcWrapper, lines, linkofinstances, problemcounter, problem, analysistimestamps.size());
            this.calculateAndSetProblemInstanceProperties(jdbcWrapper, analysistimestamps, resourceFolder, resultFolder, problemcounter, problem);
            targetLines.add(lines);
            targetLinks.add(linkofinstances);
        }
        XMLManager.writeHTML(String.valueOf(resourceFolder) + "\\template1.html", String.valueOf(resultFolder) + "\\overview.html", targetLines, targetLinks, "System\ufffdberblick");
    }

    private void calculateAndSetNumberOfInstances(JDBCWrapper jdbcWrapper, List<String> lines, List<String> linkofinstances, int problemcounter, String problem, int analysistimestampsSize) {
        String numberOfInstancesQuery = "select A.kindofproblem, A.analysistimestamp , B.numberofinstances from problemtime A left outer join ProblemTimeNum B on (A.kindofproblem=B.kindofproblem and A.analysistimestamp=B.analysistimestamp) where A.kindofproblem='" + problem + "'" + ";";
        ResultSet rsNumberofProblemInstances = jdbcWrapper.executeQuery(numberOfInstancesQuery);
        String numberOfDetailedTimestamps = this.configuration.getDashboardNumberOfRecords();
        int maxNumber = Integer.parseInt(numberOfDetailedTimestamps);
        try {
            int timecounter2 = 0;
            while (rsNumberofProblemInstances.next()) {
                ++timecounter2;
                String value = rsNumberofProblemInstances.getString(3);
                if (value != null && !value.isEmpty()) {
                    lines.add(value);
                    if (timecounter2 > analysistimestampsSize - maxNumber) {
                        linkofinstances.add("link_p" + problemcounter + "_t" + timecounter2 + ".html");
                        continue;
                    }
                    linkofinstances.add(null);
                    continue;
                }
                lines.add("X");
                linkofinstances.add("");
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
    }

    private void calculateAndSetProblemInstanceProperties(JDBCWrapper jdbcWrapper, List<String> analysistimestamps, String resourceFolder, String resultFolder, int problemcounter, String problem) {
        String numberOfDetailedTimestamps = this.configuration.getDashboardNumberOfRecords();
        int maxNumber = Integer.parseInt(numberOfDetailedTimestamps);
        List<String> filteredtimestamps = analysistimestamps;
        int timecounter = 0;
        if (analysistimestamps.size() > maxNumber) {
            filteredtimestamps = analysistimestamps.subList(analysistimestamps.size() - maxNumber, analysistimestamps.size());
            timecounter = analysistimestamps.size() - maxNumber;
        }
        for (String timestamp : filteredtimestamps) {
            ++timecounter;
            ArrayList<List<String>> targetLinesProperties = new ArrayList<List<String>>();
            String problemInstancesPropertiesQuery = "select * from tproblemproperties where problemid in (select id from tproblems where kindofproblem = #PROBLEM and analysistimestamp = #TIMESTAMP) order by id;";
            problemInstancesPropertiesQuery = problemInstancesPropertiesQuery.replaceAll("#PROBLEM", "'" + problem + "'");
            problemInstancesPropertiesQuery = problemInstancesPropertiesQuery.replaceAll("#TIMESTAMP", "'" + timestamp + "'");
            ResultSet rsProblemInstancesProperties = jdbcWrapper.executeQuery(problemInstancesPropertiesQuery);
            int oldproblemid = 0;
            try {
                if (!rsProblemInstancesProperties.next()) continue;
                try {
                    do {
                        String propertiesName = rsProblemInstancesProperties.getString(3);
                        String propertiesValue = rsProblemInstancesProperties.getString(4);
                        String currentProblemId = rsProblemInstancesProperties.getString(2);
                        ArrayList<String> column = this.createColumn(propertiesName, propertiesValue);
                        if (Integer.parseInt(currentProblemId) != oldproblemid && oldproblemid != 0) {
                            ArrayList<String> seperator = new ArrayList<String>();
                            seperator.add("-");
                            targetLinesProperties.add(seperator);
                        }
                        targetLinesProperties.add(column);
                        oldproblemid = Integer.parseInt(currentProblemId);
                    } while (rsProblemInstancesProperties.next());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                String targetLinksProperties = "link_p" + problemcounter + "_t" + timecounter + ".html";
                XMLManager.writeHTML(String.valueOf(resourceFolder) + "\\template2.html", String.valueOf(resultFolder) + "\\" + targetLinksProperties, targetLinesProperties, null, "Problemmuster: " + problem + " Timestamp: " + timestamp);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList<String> createColumn(String propertiesName, String propertiesValue) {
        ArrayList<String> column = new ArrayList<String>();
        column.add(propertiesName);
        column.add(propertiesValue);
        return column;
    }

    private void createViewProblemTime(JDBCWrapper jdbcWrapper) {
        jdbcWrapper.executeQuery("create or replace view problemtime AS select distinct A.kindofproblem, B.analysistimestamp from tproblems A inner join (select distinct analysistimestamp from tproblems ) as B on true order by A.kindofproblem,B.analysistimestamp;");
    }

    private List<String> retrieveAnalysisTimestamps(JDBCWrapper jdbcWrapper) {
        ArrayList<String> analysistimestamps = new ArrayList<String>();
        ResultSet rsTimestamps = jdbcWrapper.executeQuery("select distinct analysistimestamp from tproblems order by 1;");
        try {
            while (rsTimestamps.next()) {
                analysistimestamps.add(rsTimestamps.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return analysistimestamps;
    }

    private List<String> retrieveProblemIds(JDBCWrapper jdbcWrapper) {
        ArrayList<String> kindofproblems = new ArrayList<String>();
        ResultSet rsProblemKinds = jdbcWrapper.executeQuery("select distinct kindofproblem from tproblems;");
        try {
            while (rsProblemKinds.next()) {
                kindofproblems.add(rsProblemKinds.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return kindofproblems;
    }

    private void generateXmlAndImportDataFromDatabase() {
        JDBCWrapper jdbcWrapper = JDBCWrapper.createJDBCWrapper((DatabaseConfiguration)this.configuration.getDatabaseConfiguration());
        jdbcWrapper.getConnection();
        String resultFolder = this.configuration.getDashboardTargetDirectoryPath();
        List<String> timestamps = this.retrieveAnalysisTimestamps(jdbcWrapper);
        List<String> kindOfProblems = this.retrieveProblemIds(jdbcWrapper);
        String numberOfDetailedTimestamps = this.configuration.getDashboardNumberOfRecords();
        int maxNumber = Integer.parseInt(numberOfDetailedTimestamps);
        Document document = DocumentHelper.createDocument();
        Element root = XMLManager.setRootXML(document);
        int ocounter = 0;
        Boolean showDetails = true;
        for (String problemtimestamp : timestamps) {
            String oid = "'" + ocounter + "'";
            Element elementTimestamp = XMLManager.writeElementtoXML(root, oid, "timestamp");
            XMLManager.writeAttributetoXML(elementTimestamp, "date", problemtimestamp);
            Element elementProblemPatternlist = XMLManager.writeElementtoXML(elementTimestamp, null, "problempatternlist");
            ++ocounter;
            kindOfProblems = this.getProblemIdAtCenternTimestamp(jdbcWrapper, problemtimestamp, "ProblemTimeNum");
            if (timestamps.size() > maxNumber) {
                showDetails = ocounter < timestamps.size() - maxNumber + 1 ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            for (String problem : kindOfProblems) {
                Element elementProblemPattern = XMLManager.writeElementtoXML(elementProblemPatternlist, null, "problempattern");
                XMLManager.writeAttributetoXML(elementProblemPattern, "name", problem);
                this.writePatterPropertiesToXml(jdbcWrapper, problemtimestamp, problem, elementProblemPattern, showDetails);
            }
            kindOfProblems.clear();
        }
        XMLManager.writeDoctoXML(document, String.valueOf(resultFolder) + "\\pattern.xml");
    }

    private void writePatterPropertiesToXml(JDBCWrapper jdbcWrapper, String problemtimestamp, String problem, Element elementProblemPattern, Boolean showDetails) {
        ResultSet rsGetPatternProperties = jdbcWrapper.executeQuery("select * from tproblemproperties where problemid in (select id from tproblems where kindofproblem = '" + problem + "'" + " and analysistimestamp = " + "'" + problemtimestamp + "'" + ")" + " order by id;");
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> problemId = new ArrayList<String>();
        int numberOfProperties = 0;
        int oldProblemId = 0;
        int instanceGroup = 0;
        int groupNum = 0;
        Element problemInstancesGroup = null;
        try {
            while (rsGetPatternProperties.next()) {
                nameList.add(rsGetPatternProperties.getString(3));
                valueList.add(rsGetPatternProperties.getString(4));
                problemId.add(rsGetPatternProperties.getString(2));
                ++numberOfProperties;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Element elementProblemInstances = XMLManager.writeElementtoXML(elementProblemPattern, null, "instances");
        int j = 0;
        while (j < numberOfProperties) {
            String currentProblemId = (String)problemId.get(j);
            if (showDetails.booleanValue()) {
                if (Integer.parseInt(currentProblemId) != oldProblemId) {
                    oldProblemId = Integer.parseInt(currentProblemId);
                    String instanceId = "'" + ++instanceGroup + "'";
                    problemInstancesGroup = XMLManager.writeElementtoXML(elementProblemInstances, instanceId, "Group");
                    XMLManager.writeAttributetoXML(problemInstancesGroup, ((String)nameList.get(j)).toString(), ((String)valueList.get(j)).toString());
                } else {
                    XMLManager.writeAttributetoXML(problemInstancesGroup, ((String)nameList.get(j)).toString(), ((String)valueList.get(j)).toString());
                }
            } else {
                if (Integer.parseInt(currentProblemId) != oldProblemId) {
                    if (groupNum < 1) {
                        oldProblemId = Integer.parseInt(currentProblemId);
                        problemInstancesGroup = XMLManager.writeElementtoXML(elementProblemInstances, null, "Group");
                        XMLManager.writeAttributetoXML(problemInstancesGroup, ((String)nameList.get(j)).toString(), ((String)valueList.get(j)).toString());
                    }
                } else {
                    XMLManager.writeAttributetoXML(problemInstancesGroup, ((String)nameList.get(j)).toString(), ((String)valueList.get(j)).toString());
                }
                if (groupNum == 1) {
                    XMLManager.writeElementtoXML(elementProblemInstances, null, "Details...");
                }
                ++groupNum;
            }
            ++j;
        }
    }

    private List<String> getProblemIdAtCenternTimestamp(JDBCWrapper jdbcWrapper, String problemtimestamp, String viewProblemTimeNum) {
        ArrayList<String> kindOfProblems = new ArrayList<String>();
        ResultSet rsProblemAndNumInstances = jdbcWrapper.executeQuery("select kindofproblem, numberofinstances from " + viewProblemTimeNum + " where analysistimestamp=" + "'" + problemtimestamp + "'" + " order by kindofproblem;");
        try {
            while (rsProblemAndNumInstances.next()) {
                kindOfProblems.add(rsProblemAndNumInstances.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return kindOfProblems;
    }

    private void createViewProblemTimeNumOfInstances(JDBCWrapper jdbcWrapper) {
        jdbcWrapper.executeQuery("create or replace view ProblemTimeNum as select kindofproblem, analysistimestamp, count(*) as numberofinstances from tproblems group by kindofproblem, analysistimestamp order by kindofproblem, analysistimestamp;");
    }
}

