/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.TimeSeriesEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class TimeSeries
implements Serializable {
    private Logger logger = Logger.getLogger((String)this.getClass().getName());
    private static final long serialVersionUID = 1L;
    private String myLabel;
    List<TimeSeriesEntity> values = new ArrayList<TimeSeriesEntity>();

    public TimeSeries(String myLabel) {
        this.setLabel(myLabel);
    }

    public void add(double x, double y) {
        this.values.add(new TimeSeriesEntity(x, y));
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeSeries) {
            TimeSeries other = (TimeSeries)obj;
            if (this.getValues().size() != other.getValues().size()) {
                return false;
            }
            ArrayList thisClone = new ArrayList();
            Collections.copy(thisClone, this.getValues());
            ArrayList otherClone = new ArrayList();
            Collections.copy(otherClone, other.getValues());
            Collections.sort(thisClone);
            Collections.sort(otherClone);
            int i = 0;
            while (i < thisClone.size()) {
                if (!((TimeSeriesEntity)thisClone.get(i)).equals(otherClone.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public List<TimeSeriesEntity> getValues() {
        return this.values;
    }

    public void setLabel(String newLabel) {
        if (this.myLabel == null || this.myLabel.equals("")) {
            this.logger.error((Object)"Label of TimeSeries should not be null or an empty string");
            this.myLabel = "Time Series Generic Label";
        } else {
            this.myLabel = newLabel;
        }
    }

    public void setValues(List<TimeSeriesEntity> values) {
        this.values = values;
    }

    public String toString() {
        String result = String.valueOf(this.myLabel) + "\n";
        if (this.values != null) {
            for (TimeSeriesEntity e : this.values) {
                result = String.valueOf(result) + e + "\n";
            }
        }
        return result;
    }
}

