/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.PieEntity;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

public class Pie
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ArrayList<PieEntity> entities = new ArrayList();
    private String label;

    public Pie(String string) {
        this.label = string;
    }

    public void addEntity(PieEntity e) {
        this.entities.add(e);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pie) {
            Pie other = (Pie)obj;
            if (this.getEntities().size() != other.getEntities().size()) {
                return false;
            }
            ArrayList thisClone = new ArrayList();
            Collections.copy(thisClone, this.getEntities());
            ArrayList otherClone = new ArrayList();
            Collections.copy(otherClone, other.getEntities());
            Collections.sort(thisClone);
            Collections.sort(otherClone);
            int i = 0;
            while (i < thisClone.size()) {
                if (!((PieEntity)thisClone.get(i)).equals(otherClone.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private Collection<PieEntity> getAggregatedPie(int maxCount) {
        ArrayList<PieEntity> newEntities = new ArrayList<PieEntity>();
        double sum = 0.0;
        int i = this.entities.size() - 1;
        while (i >= this.entities.size() - maxCount) {
            newEntities.add(this.entities.get(i));
            sum += this.entities.get(i).getValue();
            --i;
        }
        double remaining = 0.0;
        while (i >= 0) {
            remaining += this.entities.get(i).getValue();
            --i;
        }
        DecimalFormat df = new DecimalFormat("#0.0", new DecimalFormatSymbols(Locale.US));
        newEntities.add(new PieEntity(remaining, "Other (" + df.format(remaining * 100.0 / (sum += remaining)) + "%)"));
        Collections.sort(newEntities);
        return newEntities;
    }

    public ArrayList<PieEntity> getEntities() {
        return this.entities;
    }

    public Collection<PieEntity> getEntities(int maxCount) {
        Collections.sort(this.entities);
        if (this.entities.size() > maxCount && maxCount > 0) {
            return this.getAggregatedPie(maxCount);
        }
        return this.entities;
    }

    public String getLabel() {
        return this.label;
    }
}

