/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcmbench.tabs.operations;

import de.uka.ipd.sdq.pcmbench.tabs.operations.DialogCellLayout;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class TypeDialogCellEditor
extends DialogCellEditor {
    private Composite editor;
    private Control contents;
    private Button selButton;
    private Button delButton;
    private FocusListener buttonFocusListener;
    private Object value = null;

    public TypeDialogCellEditor(Composite composite, SelectionListener cellValueListener) {
        super(composite, 127);
        if (this.delButton != null) {
            this.delButton.addSelectionListener(cellValueListener);
        }
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.contents = this.createContents(this.editor);
        this.updateContents(this.value);
        this.delButton = new Button(this.editor, 1024);
        this.delButton.setText("X");
        this.delButton.setFont(font);
        this.selButton = this.createButton(this.editor);
        this.selButton.setFont(font);
        this.editor.setLayout((Layout)new DialogCellLayout(this.contents, this.selButton, this.delButton));
        this.selButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    TypeDialogCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.selButton.addFocusListener(this.getButtonFocusListener());
        this.selButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TypeDialogCellEditor.this.selButton.removeFocusListener(TypeDialogCellEditor.this.getButtonFocusListener());
                Object newValue = TypeDialogCellEditor.this.openDialogBox((Control)TypeDialogCellEditor.this.editor);
                TypeDialogCellEditor.this.selButton.addFocusListener(TypeDialogCellEditor.this.getButtonFocusListener());
                if (newValue != null) {
                    boolean newValidState = TypeDialogCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        TypeDialogCellEditor.this.markDirty();
                        TypeDialogCellEditor.this.doSetValue(newValue);
                    } else {
                        TypeDialogCellEditor.this.setErrorMessage(MessageFormat.format(TypeDialogCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    TypeDialogCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    private FocusListener getButtonFocusListener() {
        if (this.buttonFocusListener == null) {
            this.buttonFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    TypeDialogCellEditor.this.focusLost();
                }
            };
        }
        return this.buttonFocusListener;
    }

    protected void doSetFocus() {
        this.selButton.setFocus();
    }

    protected void doSetValue(Object value) {
        super.doSetValue(value);
    }
}

