/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcmbench.tabs.generic;

import de.uka.ipd.sdq.pcmbench.tabs.PCMBenchTabsImages;
import de.uka.ipd.sdq.pcmbench.tabs.generic.ObservableCellModifier;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class EditorSection
implements Observer {
    private Composite composite;
    private ToolItem addButton;
    private ToolItem deleteButton;
    protected TableViewer viewer;
    private EObject selectedObject = null;

    public EditorSection(Composite composite) {
        composite.getParent().setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite = composite;
        this.createEditorSection();
    }

    private void createEditorSection() {
        this.createTableSection(this.createToolBar());
    }

    protected ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar(this.composite, 0x820200);
        FormData formData = new FormData();
        formData.left = new FormAttachment(96, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        toolBar.setLayoutData((Object)formData);
        if (this.canAddButonCreated()) {
            this.addButton = new ToolItem(toolBar, 8);
            this.addButton.setImage(PCMBenchTabsImages.imageRegistry.get("add_sign"));
            this.addButton.addSelectionListener(this.createAddButtonActionListener());
        }
        if (this.canDeleteButonCreated()) {
            this.deleteButton = new ToolItem(toolBar, 8);
            this.deleteButton.setImage(PCMBenchTabsImages.imageRegistry.get("delete_sign"));
            this.deleteButton.setEnabled(false);
        }
        return toolBar;
    }

    protected void createTableSection(ToolBar toolBar) {
        int style = 101124;
        int widthBoard = 6;
        Table table = new Table(this.composite, style);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)toolBar, widthBoard);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setColumnProperties(this.getTableColumnNames());
        this.viewer.setCellEditors(this.createViewerCellEditors(table));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object input = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (input instanceof EObject) {
                    EditorSection.this.selectedObject = (EObject)input;
                    EditorSection.this.setDeleteButtonEnabled(EditorSection.this.inputValidation(EditorSection.this.selectedObject));
                } else {
                    EditorSection.this.setDeleteButtonEnabled(false);
                }
            }
        });
        this.setDeleteButtonListener(this.viewer);
        this.setViewerCellModifier(this.viewer);
        this.createTableColumns(table);
    }

    protected abstract void createTableColumns(Table var1);

    protected abstract boolean inputValidation(EObject var1);

    protected void setDeleteButtonListener(TableViewer viewer) {
        SelectionListener listener = this.createDeleteButtonListener();
        viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        if (this.canDeleteButonCreated()) {
            this.deleteButton.addSelectionListener(listener);
        }
    }

    protected void setViewerCellModifier(TableViewer viewer) {
        ObservableCellModifier cellModifier = this.createViewerCellModifier();
        cellModifier.addObserver(this);
        viewer.setCellModifier((ICellModifier)cellModifier);
    }

    protected abstract SelectionListener createDeleteButtonListener();

    protected abstract String[] getTableColumnNames();

    protected abstract boolean canAddButonCreated();

    protected abstract boolean canDeleteButonCreated();

    protected abstract CellEditor[] createViewerCellEditors(Table var1);

    protected abstract ObservableCellModifier createViewerCellModifier();

    public void setViewerCellModifier(ICellModifier modifier) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.setCellModifier(modifier);
    }

    public void addViewerSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.addSelectionChangedListener(listener);
    }

    protected abstract SelectionListener createAddButtonActionListener();

    public void setViewerInput(Object input) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.setInput(input);
    }

    public void setViewerContentProvider(IContentProvider contentProvider) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.setContentProvider(contentProvider);
    }

    public void setViewerLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.setLabelProvider(labelProvider);
    }

    public void refresh() {
        Assert.isNotNull((Object)this.viewer);
        this.viewer.refresh();
    }

    protected void setDeleteButtonEnabled(boolean enabled) {
        this.deleteButton.setEnabled(enabled);
    }

    public EObject getSelectedObject() {
        return this.selectedObject;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }
}

