/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreloadingListIterator<T>
implements ListIterator<T> {
    private List<T> elementHistory = new ArrayList<T>();
    private int pointer = 0;
    private Iterator<T> wrappedIterator;

    public PreloadingListIterator(Iterator<T> wrappedIterator) {
        this.wrappedIterator = wrappedIterator;
    }

    @Override
    public boolean hasNext() {
        if (!this.isPointerInHistory()) {
            return this.wrappedIterator.hasNext();
        }
        return true;
    }

    @Override
    public T next() {
        Object next = null;
        if (this.hasNext()) {
            if (this.isPointerInHistory()) {
                next = this.elementHistory.get(this.pointer);
            } else {
                next = this.wrappedIterator.next();
                this.elementHistory.add(next);
            }
            ++this.pointer;
        }
        return (T)next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T o) {
        throw new UnsupportedOperationException();
    }

    public int preloadNext(int count) {
        int oldPointer = this.pointer;
        while (count > 0 && this.hasNext()) {
            this.next();
            --count;
        }
        int loadedElements = this.pointer - oldPointer;
        this.pointer = oldPointer;
        return loadedElements;
    }

    @Override
    public boolean hasPrevious() {
        return this.pointer != 0;
    }

    @Override
    public int nextIndex() {
        return this.pointer;
    }

    @Override
    public T previous() {
        if (this.hasPrevious()) {
            --this.pointer;
            return this.elementHistory.get(this.pointer);
        }
        return null;
    }

    @Override
    public int previousIndex() {
        return this.pointer - 1;
    }

    @Override
    public void set(T o) {
        throw new UnsupportedOperationException();
    }

    private boolean isPointerInHistory() {
        return this.pointer < this.elementHistory.size();
    }
}

