/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    public static <T> Collection<T> copyOrNull(Collection<T> source) {
        if (source == null) {
            return null;
        }
        return new ArrayList<T>(source);
    }

    public static <T> Collection<T> addIfNotNull(Collection<T> c, T element) {
        if (element != null) {
            c.add(element);
        }
        return c;
    }

    public static <T> Collection<T> addAllIfNotNull(Collection<T> c, Collection<T> elements) {
        if (elements != null) {
            c.addAll(elements);
        }
        return c;
    }

    public static <T> Collection<T> union(Collection<T> a, Collection<T> b) {
        if (a == null) {
            if (b == null) {
                return null;
            }
            return b;
        }
        return CollectionUtils.addAllIfNotNull(a, b);
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        Iterator<T> iterator;
        if (iterable != null && (iterator = iterable.iterator()).hasNext()) {
            ArrayList<T> result = new ArrayList<T>();
            do {
                result.add(iterator.next());
            } while (iterator.hasNext());
            return result;
        }
        return null;
    }

    public static <T> boolean isNotEmpty(Collection<T> c) {
        return c != null && !c.isEmpty();
    }

    public static <T> boolean isEmpty(Collection<T> c) {
        return c == null || c.isEmpty();
    }

    public static boolean equalsNullSafe(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.equals(two);
    }

    public static <T> T findEquivalent(List<T> list, T object) {
        int index = list.indexOf(object);
        return index < 0 ? null : (T)list.get(index);
    }
}

