/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChainedIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Iterator<? extends T> thisIterator;
    private Iterator<? extends T> nextIterator;

    public ChainedIterator(Iterator<? extends T> first, Iterator<? extends T> second) {
        if (first == null) {
            throw new NullPointerException("The first iterator may not be null");
        }
        this.thisIterator = first;
        this.nextIterator = second;
    }

    private Iterator<? extends T> getIter() {
        if (this.thisIterator.hasNext()) {
            return this.thisIterator;
        }
        return this.nextIterator != null ? this.nextIterator : this.thisIterator;
    }

    @Override
    public boolean hasNext() {
        return this.getIter().hasNext();
    }

    @Override
    public T next() {
        return this.getIter().next();
    }

    @Override
    public void remove() {
        this.getIter().remove();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

