/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.runtime.impl;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.index.IndexStore;
import org.eclipse.emf.index.resource.ResourceIndexer;
import org.eclipse.emf.index.resource.impl.IndexFeederImpl;
import org.eclipse.emf.index.resource.impl.SimpleResourceIndexerRegistryImpl;

public class IndexAwareResourceSet
extends ResourceSetImpl {
    private IndexStore store;
    @Inject(optional=true)
    private final ResourceIndexer.Registry registry = new SimpleResourceIndexerRegistryImpl();

    public void addIndexer(IndexEntry entry) {
        this.registry.registerIndexer(entry.getFileExtension(), entry.getIndexer());
    }

    @Inject
    public void setIndexStore(IndexStore indexStore) {
        this.store = indexStore;
    }

    public Resource createResource(URI uri, String contentType) {
        try {
            Resource resource = super.createResource(uri, contentType);
            return resource;
        }
        finally {
            ResourceIndexer indexer = this.registry.getIndexerFor(uri.fileExtension());
            IndexFeederImpl feeder = new IndexFeederImpl(this.store);
            indexer.resourceChanged(uri, feeder);
            feeder.commit();
        }
    }

    public IndexStore getStore() {
        return this.store;
    }

    public static class IndexEntry {
        private String fileExtension;
        private ResourceIndexer indexer;

        public IndexEntry(String fileExtension, ResourceIndexer indexer) {
            this.fileExtension = fileExtension;
            this.indexer = indexer;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public void setFileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        public ResourceIndexer getIndexer() {
            return this.indexer;
        }

        public void setIndexer(ResourceIndexer indexer) {
            this.indexer = indexer;
        }
    }
}

