/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.resource.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.index.internal.LogFacade;
import org.eclipse.emf.index.resource.IndexFeeder;
import org.eclipse.emf.index.resource.ResourceIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceIndexerImpl
implements ResourceIndexer {
    @Override
    public void resourceChanged(URI resourceURI, IndexFeeder indexFeeder) {
        Resource resource = this.loadResource(resourceURI);
        this.resourceChanged(resource, indexFeeder);
    }

    protected Resource loadResource(URI resourceURI) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            return resourceSet.getResource(resourceURI, true);
        }
        catch (Exception exc) {
            LogFacade.logError("Error loading resource", exc);
            return null;
        }
    }

    public void resourceChanged(Resource resource, IndexFeeder feeder) {
        if (resource != null) {
            try {
                URIConverter uriConverter = this.getURIConverter(resource);
                feeder.createResourceDescriptor(resource, this.getResourceUserData(resource));
                TreeIterator i = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
                while (i.hasNext()) {
                    EObject element = (EObject)i.next();
                    if (!this.isIndexElement(element)) continue;
                    feeder.createEObjectDescriptor(element, this.getEObjectName(element), this.getEObjectDisplayName(element), this.getEObjectUserData(element));
                    URI sourceURI = uriConverter.normalize(EcoreUtil.getURI((EObject)element));
                    if (sourceURI == null) continue;
                    for (EReference eReference : element.eClass().getEAllReferences()) {
                        String eReferenceName = eReference.getName();
                        if (!this.isIndexReference(eReference, element)) continue;
                        if (eReference.isMany()) {
                            List targets = (List)element.eGet((EStructuralFeature)eReference, false);
                            int index = 0;
                            while (index < targets.size()) {
                                Object target = targets.get(index);
                                this.createEReferenceDescriptor(feeder, uriConverter, sourceURI, eReferenceName, index, target);
                                ++index;
                            }
                            continue;
                        }
                        Object target = element.eGet((EStructuralFeature)eReference, false);
                        this.createEReferenceDescriptor(feeder, uriConverter, sourceURI, eReferenceName, -1, target);
                    }
                }
            }
            catch (Exception exc) {
                LogFacade.logError("Error indexing resource " + resource.getURI(), exc);
            }
        }
    }

    protected URIConverter getURIConverter(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        return resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
    }

    @Override
    public void resourceDeleted(URI resourceURI, IndexFeeder feeder) {
        try {
            feeder.deleteResourceDescriptor(resourceURI);
        }
        catch (Exception exc) {
            LogFacade.logError("Error deleting resource from index " + resourceURI, exc);
        }
    }

    protected void createEReferenceDescriptor(IndexFeeder feeder, URIConverter uriConverter, URI sourceURI, String eReferenceName, int index, Object target) {
        URI targetURI;
        if (target instanceof EObject && (targetURI = uriConverter.normalize(EcoreUtil.getURI((EObject)((EObject)target)))) != null) {
            feeder.createEReferenceDescriptor(sourceURI, eReferenceName, index, targetURI);
        }
    }

    protected Map<String, Serializable> getResourceUserData(Resource resource) {
        return null;
    }

    protected boolean isIndexElement(EObject element) {
        return true;
    }

    protected String getEObjectName(EObject eObject) {
        EStructuralFeature nameFeature = eObject.eClass().getEStructuralFeature("name");
        if (nameFeature != null && nameFeature.getEType() instanceof EDataType) {
            if (!nameFeature.isMany()) {
                Object nameFeatureValue = eObject.eGet(nameFeature);
                return nameFeatureValue == null ? null : nameFeatureValue.toString();
            }
            List names = (List)eObject.eGet(nameFeature);
            StringBuilder b = new StringBuilder();
            Iterator nameIter = names.iterator();
            while (nameIter.hasNext()) {
                b.append(nameIter.next().toString());
            }
            return b.toString();
        }
        return null;
    }

    protected String getEObjectDisplayName(EObject eObject) {
        String displayName = this.getEObjectName(eObject);
        if (displayName == null) {
            displayName = eObject.eResource().getURIFragment(eObject);
        }
        return displayName;
    }

    protected Map<String, Serializable> getEObjectUserData(EObject eObject) {
        return null;
    }

    protected boolean isIndexReference(EReference eReference, EObject element) {
        return !eReference.isContainment() && !eReference.isDerived() && element.eIsSet((EStructuralFeature)eReference);
    }
}

