/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.resource.impl;

import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.index.EObjectDescriptor;
import org.eclipse.emf.index.EReferenceDescriptor;
import org.eclipse.emf.index.IndexStore;
import org.eclipse.emf.index.IndexingException;
import org.eclipse.emf.index.ResourceDescriptor;
import org.eclipse.emf.index.ecore.EClassDescriptor;
import org.eclipse.emf.index.ecore.EcoreIndexFeeder;
import org.eclipse.emf.index.impl.EObjectDescriptorImpl;
import org.eclipse.emf.index.impl.EReferenceDescriptorImpl;
import org.eclipse.emf.index.impl.ResourceDescriptorImpl;
import org.eclipse.emf.index.internal.LogFacade;
import org.eclipse.emf.index.resource.IndexFeeder;
import org.eclipse.emf.index.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexFeederImpl
implements IndexFeeder {
    private IndexStore index;
    @Inject(optional=true)
    private EcoreIndexFeeder ecoreIndexFeeder;
    private List<URI> deleteResourceURIs = new ArrayList<URI>();
    private Map<Resource, ResourceData> resourceDataCache = new HashMap<Resource, ResourceData>();
    private Map<EObject, EObjectData> eObjectDataCache = new HashMap<EObject, EObjectData>();
    private List<EReferenceData> eReferenceCache = new ArrayList<EReferenceData>();
    private Map<URI, ResourceDescriptor> resourceDescCacheUri = new HashMap<URI, ResourceDescriptor>();
    private Map<EObject, EObjectDescriptor> eObjectDescCache = new HashMap<EObject, EObjectDescriptor>();
    private List<EObjectDescriptor> allExistingEObjectDescs = new ArrayList<EObjectDescriptor>();
    private List<EReferenceDescriptor> allExistingEReferenceDescs = new ArrayList<EReferenceDescriptor>();

    @Inject
    public IndexFeederImpl(IndexStore indexStore) {
        this.index = indexStore;
    }

    @Override
    public void deleteResourceDescriptor(URI resourceURI) throws IndexingException {
        for (Resource addedResources : this.resourceDataCache.keySet()) {
            if (!addedResources.getURI().equals((Object)resourceURI)) continue;
            throw new IndexingException("Cannot add and remove resource in the same transaction", resourceURI);
        }
        this.deleteResourceURIs.add(resourceURI);
    }

    @Override
    public void createResourceDescriptor(Resource resource, Map<String, Serializable> userData) throws IndexingException {
        URI resourceURI = resource.getURI();
        for (URI deleteResourceURI : this.deleteResourceURIs) {
            if (!resourceURI.equals((Object)deleteResourceURI)) continue;
            throw new IndexingException("Cannot add and remove resource in the same transaction", resourceURI);
        }
        ResourceData resourceData = new ResourceData();
        resourceData.uri = resourceURI.toString();
        resourceData.indexingDate = System.currentTimeMillis();
        resourceData.userData = userData;
        this.resourceDataCache.put(resource, resourceData);
    }

    @Override
    public void createEObjectDescriptor(EObject eObject, String name, String displayName, Map<String, Serializable> userData) {
        Resource eResource = eObject.eResource();
        if (eResource != null) {
            EObjectData eObjectData = new EObjectData();
            eObjectData.fragment = eResource.getURIFragment(eObject);
            eObjectData.name = name;
            eObjectData.displayName = displayName;
            eObjectData.userData = userData;
            this.eObjectDataCache.put(eObject, eObjectData);
        } else {
            LogFacade.logError("Cannot index an EObject that is not contained in a resource");
        }
    }

    @Override
    public void createEReferenceDescriptor(URI sourceURI, String eReferenceName, int index, URI targetURI) {
        if (sourceURI != null && eReferenceName != null && targetURI != null) {
            EReferenceData eReferenceData = new EReferenceData();
            eReferenceData.sourceURI = sourceURI;
            eReferenceData.targetURI = targetURI;
            eReferenceData.eReferenceName = eReferenceName;
            eReferenceData.index = index;
            this.eReferenceCache.add(eReferenceData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        try {
            IndexStore indexStore = this.index;
            synchronized (indexStore) {
                this.index.beginWrite();
                try {
                    this.commitResourceDescriptors();
                    this.commitEObjectDescriptors();
                    this.commitEReferenceDescriptors();
                    this.deleteStaleDescriptors();
                }
                finally {
                    this.index.endWrite();
                }
            }
        }
        finally {
            this.clearAllCaches();
        }
    }

    public void commitResourceDescriptors() {
        for (Map.Entry<Resource, ResourceData> resourceEntry : this.resourceDataCache.entrySet()) {
            Resource resource = resourceEntry.getKey();
            ResourceData data = resourceEntry.getValue();
            ResourceDescriptor existingResourceDesc = this.index.resourceDAO().createQueryResource(resource).executeSingleResult();
            ResourceDescriptorImpl newResourceDescriptor = new ResourceDescriptorImpl(data.uri, data.indexingDate, data.userData);
            if (existingResourceDesc != null) {
                List<EObjectDescriptor> existingEObjectsInResource = CollectionUtils.toList(this.index.eObjectDAO().createQueryEObjectsInResource(existingResourceDesc).executeListResult());
                CollectionUtils.addAllIfNotNull(this.allExistingEObjectDescs, existingEObjectsInResource);
                List existingEReferencesFromResource = CollectionUtils.toList(this.index.eReferenceDAO().createQuery().sourceResource(existingResourceDesc).executeListResult());
                CollectionUtils.addAllIfNotNull(this.allExistingEReferenceDescs, existingEReferencesFromResource);
                this.index.resourceDAO().modify(existingResourceDesc, newResourceDescriptor);
                this.putResourceDescriptor(resource, existingResourceDesc);
                continue;
            }
            this.index.resourceDAO().store(newResourceDescriptor);
            this.putResourceDescriptor(resource, newResourceDescriptor);
        }
    }

    private void putResourceDescriptor(Resource resource, ResourceDescriptor resourceDescriptor) {
        this.resourceDescCacheUri.put(resource.getURI(), resourceDescriptor);
    }

    public void commitEObjectDescriptors() {
        for (Map.Entry<EObject, EObjectData> eObjectEntry : this.eObjectDataCache.entrySet()) {
            EObject eObject = eObjectEntry.getKey();
            EObjectData data = eObjectEntry.getValue();
            Resource resource = eObject.eResource();
            ResourceDescriptor resourceDesc = null;
            resourceDesc = resource != null ? this.findResourceDescriptor(resource.getURI()) : this.findResourceDescriptor(EcoreUtil.getURI((EObject)eObject).trimFragment());
            EClass eClass = eObject.eClass();
            EClassDescriptor eClassDescriptor = this.findEClassDescriptor(eClass);
            if (eClassDescriptor == null) {
                LogFacade.logError("Couldn't find EClassDescriptor for EClass " + eClass.getName());
                continue;
            }
            EObjectDescriptorImpl newEObjectDesc = new EObjectDescriptorImpl(resourceDesc, data.fragment, data.name, data.displayName, eClassDescriptor, data.userData);
            EObjectDescriptor existingEObjectDesc = CollectionUtils.findEquivalent(this.allExistingEObjectDescs, newEObjectDesc);
            if (existingEObjectDesc != null) {
                this.index.eObjectDAO().modify(existingEObjectDesc, newEObjectDesc);
                this.allExistingEObjectDescs.remove(existingEObjectDesc);
                this.eObjectDescCache.put(eObject, existingEObjectDesc);
                continue;
            }
            this.index.eObjectDAO().store(newEObjectDesc);
            this.eObjectDescCache.put(eObject, newEObjectDesc);
        }
    }

    private EClassDescriptor findEClassDescriptor(EClass eClass) {
        EClassDescriptor eClassDescriptor = this.index.eClassDAO().createQueryEClass(eClass).executeSingleResult();
        if (eClassDescriptor == null && this.ecoreIndexFeeder != null && eClass.getEPackage() != null) {
            this.ecoreIndexFeeder.index(eClass.getEPackage(), false);
            eClassDescriptor = this.index.eClassDAO().createQueryEClass(eClass).executeSingleResult();
        }
        return eClassDescriptor;
    }

    public void commitEReferenceDescriptors() {
        for (EReferenceData data : this.eReferenceCache) {
            ResourceDescriptor sourceResourceDescriptor = this.findResourceDescriptor(data.sourceURI.trimFragment());
            ResourceDescriptor targetResourceDescriptor = this.findResourceDescriptor(data.targetURI.trimFragment());
            EReferenceDescriptorImpl eReferenceDesc = new EReferenceDescriptorImpl(sourceResourceDescriptor, data.sourceURI.fragment(), data.eReferenceName, data.index, targetResourceDescriptor, data.targetURI.fragment());
            if (this.allExistingEReferenceDescs.remove(eReferenceDesc)) continue;
            this.index.eReferenceDAO().store(eReferenceDesc);
        }
    }

    public void deleteStaleDescriptors() {
        for (URI deleteResourceURI : this.deleteResourceURIs) {
            ResourceDescriptor deleteResourceDescriptor = (ResourceDescriptor)this.index.resourceDAO().createQuery().uri(deleteResourceURI.toString()).executeSingleResult();
            if (deleteResourceDescriptor == null) continue;
            List<EObjectDescriptor> deleteEObjects = CollectionUtils.toList(this.index.eObjectDAO().createQueryEObjectsInResource(deleteResourceDescriptor).executeListResult());
            CollectionUtils.addAllIfNotNull(this.allExistingEObjectDescs, deleteEObjects);
            List<EReferenceDescriptor> deleteEReferences = CollectionUtils.toList(this.index.eReferenceDAO().createQueryEReferencesFromResource(deleteResourceDescriptor).executeListResult());
            CollectionUtils.addAllIfNotNull(this.allExistingEReferenceDescs, deleteEReferences);
            this.index.resourceDAO().delete(deleteResourceDescriptor);
        }
        for (EObjectDescriptor eObjectDesc : this.allExistingEObjectDescs) {
            this.index.eObjectDAO().delete(eObjectDesc);
        }
        for (EReferenceDescriptor eReferenceDesc : this.allExistingEReferenceDescs) {
            this.index.eReferenceDAO().delete(eReferenceDesc);
        }
    }

    private ResourceDescriptor findResourceDescriptor(URI uri) {
        ResourceDescriptor resourceDescriptor = this.resourceDescCacheUri.get(uri);
        if (resourceDescriptor == null) {
            String uriAsString = uri.toString();
            resourceDescriptor = (ResourceDescriptor)this.index.resourceDAO().createQuery().uri(uriAsString).executeSingleResult();
            if (resourceDescriptor == null) {
                resourceDescriptor = new ResourceDescriptorImpl(uriAsString, Long.MIN_VALUE, null);
                this.index.resourceDAO().store(resourceDescriptor);
            }
        }
        return resourceDescriptor;
    }

    public void clearAllCaches() {
        this.resourceDataCache.clear();
        this.eObjectDataCache.clear();
        this.eReferenceCache.clear();
        this.resourceDescCacheUri.clear();
        this.eObjectDescCache.clear();
        this.allExistingEObjectDescs.clear();
        this.allExistingEReferenceDescs.clear();
        this.deleteResourceURIs.clear();
    }

    private static class EObjectData {
        String name;
        String fragment;
        String displayName;
        Map<String, Serializable> userData;

        private EObjectData() {
        }
    }

    private static class EReferenceData {
        URI sourceURI;
        URI targetURI;
        String eReferenceName;
        int index;

        private EReferenceData() {
        }
    }

    private static class ResourceData {
        String uri;
        long indexingDate;
        Map<String, Serializable> userData;

        private ResourceData() {
        }
    }
}

