/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.index.IGenericQuery;
import org.eclipse.emf.index.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InverseReferenceCache<TargetType, SourceDescType> {
    private Map<TargetType, Set<SourceDescType>> resultMap = new HashMap<TargetType, Set<SourceDescType>>();

    public void put(SourceDescType sourceDescriptor) {
        List<TargetType> targetDescriptors = this.targets(sourceDescriptor);
        for (TargetType targetDescriptor : targetDescriptors) {
            Set<SourceDescType> sources = this.resultMap.get(targetDescriptor);
            if (sources == null) {
                sources = new HashSet<SourceDescType>();
                this.resultMap.put(targetDescriptor, sources);
            }
            sources.add(sourceDescriptor);
        }
    }

    public void remove(SourceDescType sourceDescriptor) {
        List<TargetType> targetDescriptors = this.targets(sourceDescriptor);
        for (TargetType targetDescriptor : targetDescriptors) {
            Set<SourceDescType> sources = this.resultMap.get(targetDescriptor);
            if (sources == null) continue;
            sources.remove(sourceDescriptor);
            if (!sources.isEmpty()) continue;
            this.resultMap.remove(targetDescriptor);
        }
    }

    protected abstract List<TargetType> targets(SourceDescType var1);

    public Collection<SourceDescType> lookup(TargetType targetDescriptor) {
        return this.resultMap.get(targetDescriptor);
    }

    public Collection<SourceDescType> lookup(TargetType parentScopeDescriptor, IGenericQuery<TargetType> parentScopeQuery) {
        Collection<SourceDescType> queryScope = null;
        boolean isScopeDefined = false;
        if (parentScopeDescriptor != null) {
            queryScope = this.lookup(parentScopeDescriptor);
            isScopeDefined = true;
        }
        if (parentScopeQuery != null) {
            isScopeDefined = true;
            Iterable<TargetType> parentScopes = parentScopeQuery.executeListResult();
            if (parentScopes != null) {
                for (TargetType parentScope : parentScopes) {
                    queryScope = CollectionUtils.union(queryScope, this.lookup(parentScope));
                }
            }
        }
        return isScopeDefined && queryScope == null ? Collections.emptyList() : queryScope;
    }

    public IGenericQuery<SourceDescType> createQuery(TargetType targetDescriptor) {
        return new Query(targetDescriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Query
    implements IGenericQuery<SourceDescType> {
        private TargetType target;

        protected Query(TargetType target) {
            this.target = target;
        }

        @Override
        public Collection<SourceDescType> executeListResult() {
            return CollectionUtils.copyOrNull(InverseReferenceCache.this.lookup(this.target));
        }

        @Override
        public SourceDescType executeSingleResult() {
            Collection result = InverseReferenceCache.this.lookup(this.target);
            if (result != null && !result.isEmpty()) {
                return result.iterator().next();
            }
            return null;
        }
    }
}

