/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.index.EReferenceDescriptor;
import org.eclipse.emf.index.IGenericQuery;
import org.eclipse.emf.index.IndexStore;
import org.eclipse.emf.index.ResourceDescriptor;
import org.eclipse.emf.index.impl.DefaultQueryTool;
import org.eclipse.emf.index.impl.memory.BasicMemoryDAOImpl;
import org.eclipse.emf.index.impl.memory.InverseReferenceCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EReferenceDAOImpl
extends BasicMemoryDAOImpl<EReferenceDescriptor>
implements EReferenceDescriptor.DAO {
    private static final long serialVersionUID = -2728570457091998837L;
    protected transient InverseReferenceCache<ResourceDescriptor, EReferenceDescriptor> sourceResourceScope;
    protected transient InverseReferenceCache<ResourceDescriptor, EReferenceDescriptor> targetResourceScope;

    @Override
    public void store(EReferenceDescriptor element) {
        super.store(element);
        this.sourceResourceScope.put(element);
        this.targetResourceScope.put(element);
    }

    @Override
    public void delete(EReferenceDescriptor element) {
        super.delete(element);
        this.sourceResourceScope.remove(element);
        this.targetResourceScope.remove(element);
    }

    @Override
    public void initialize(IndexStore indexStore) {
        super.initialize(indexStore);
        this.sourceResourceScope = new InverseReferenceCache<ResourceDescriptor, EReferenceDescriptor>(){

            @Override
            protected List<ResourceDescriptor> targets(EReferenceDescriptor source) {
                return Collections.singletonList(source.getSourceResourceDescriptor());
            }
        };
        this.targetResourceScope = new InverseReferenceCache<ResourceDescriptor, EReferenceDescriptor>(){

            @Override
            protected List<ResourceDescriptor> targets(EReferenceDescriptor source) {
                return Collections.singletonList(source.getTargetResourceDescriptor());
            }
        };
        for (EReferenceDescriptor eReferenceDescriptor : this.store) {
            this.sourceResourceScope.put(eReferenceDescriptor);
            this.targetResourceScope.put(eReferenceDescriptor);
        }
    }

    @Override
    protected boolean doModify(EReferenceDescriptor element, Object modification) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EReferenceDescriptor.Query createQuery() {
        return new EReferenceQuery();
    }

    @Override
    public IGenericQuery<EReferenceDescriptor> createQueryEReferencesTo(EObject target) {
        return DefaultQueryTool.createQueryEReferencesTo((EReferenceDescriptor.DAO)this, target);
    }

    @Override
    public IGenericQuery<EReferenceDescriptor> createQueryEReferencesFrom(URI sourceURI) {
        return DefaultQueryTool.createQueryEReferencesFrom(this, sourceURI);
    }

    @Override
    public IGenericQuery<EReferenceDescriptor> createQueryEReferencesTo(URI targetURI) {
        return DefaultQueryTool.createQueryEReferencesTo((EReferenceDescriptor.DAO)this, targetURI);
    }

    @Override
    public IGenericQuery<EReferenceDescriptor> createQueryEReferencesFromResource(ResourceDescriptor resourceDescriptor) {
        return this.sourceResourceScope.createQuery(resourceDescriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EReferenceQuery
    extends BasicMemoryDAOImpl.Query
    implements EReferenceDescriptor.Query {
        private String sourceFragmentPattern;
        private String targetFragmentPattern;
        private ResourceDescriptor sourceResourceDescriptor;
        private ResourceDescriptor targetResourceDescriptor;
        private ResourceDescriptor.Query sourceResourceQuery;
        private ResourceDescriptor.Query targetResourceQuery;
        private String referenceNamePattern;
        private int index = -1;

        protected EReferenceQuery() {
        }

        @Override
        public EReferenceQuery sourceFragment(String pattern) {
            this.sourceFragmentPattern = pattern;
            return this;
        }

        @Override
        public EReferenceQuery targetFragment(String pattern) {
            this.targetFragmentPattern = pattern;
            return this;
        }

        @Override
        public ResourceDescriptor.Query sourceResource() {
            if (this.sourceResourceDescriptor != null) {
                throw new IllegalStateException("SourceQuery already configured");
            }
            this.sourceResourceQuery = EReferenceDAOImpl.this.indexStore.resourceDAO().createQuery();
            return this.sourceResourceQuery;
        }

        @Override
        public ResourceDescriptor.Query targetResource() {
            if (this.targetResourceDescriptor != null) {
                throw new IllegalStateException("TargetQuery already configured");
            }
            this.targetResourceQuery = EReferenceDAOImpl.this.indexStore.resourceDAO().createQuery();
            return this.targetResourceQuery;
        }

        @Override
        public EReferenceQuery sourceResource(ResourceDescriptor sourceResourceDescriptor) {
            if (this.sourceResourceQuery != null) {
                throw new IllegalStateException("SourceQuery already configured");
            }
            this.sourceResourceDescriptor = sourceResourceDescriptor;
            return this;
        }

        @Override
        public EReferenceQuery targetResource(ResourceDescriptor targetResourceDescriptor) {
            if (this.targetResourceQuery != null) {
                throw new IllegalStateException("TargetQuery already configured");
            }
            this.targetResourceDescriptor = targetResourceDescriptor;
            return this;
        }

        @Override
        public EReferenceQuery referenceName(String pattern) {
            this.referenceNamePattern = pattern;
            return this;
        }

        @Override
        public EReferenceQuery index(int index) {
            this.index = index;
            return this;
        }

        protected boolean matches(EReferenceDescriptor eReferenceDescriptor) {
            return this.matchesGlobbing(eReferenceDescriptor.getReferenceName(), this.referenceNamePattern) && this.matchesGlobbing(eReferenceDescriptor.getSourceFragment(), this.sourceFragmentPattern) && this.matchesGlobbing(eReferenceDescriptor.getTargetFragment(), this.targetFragmentPattern) && (this.index == -1 || this.index == eReferenceDescriptor.getIndex());
        }

        protected Collection<EReferenceDescriptor> scope() {
            Collection<EReferenceDescriptor> eReferencesByTargetResource;
            Collection<EReferenceDescriptor> eReferencesBySourceResource = EReferenceDAOImpl.this.sourceResourceScope.lookup(this.sourceResourceDescriptor, this.sourceResourceQuery);
            Collection<EReferenceDescriptor> mergedScopes = this.mergeScopes(eReferencesBySourceResource, eReferencesByTargetResource = EReferenceDAOImpl.this.targetResourceScope.lookup(this.targetResourceDescriptor, this.targetResourceQuery));
            return mergedScopes == null ? super.scope() : mergedScopes;
        }
    }
}

