/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl.memory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.index.EObjectDescriptor;
import org.eclipse.emf.index.IGenericQuery;
import org.eclipse.emf.index.IndexStore;
import org.eclipse.emf.index.ResourceDescriptor;
import org.eclipse.emf.index.ecore.EClassDescriptor;
import org.eclipse.emf.index.impl.DefaultQueryTool;
import org.eclipse.emf.index.impl.EObjectDescriptorImpl;
import org.eclipse.emf.index.impl.memory.BasicMemoryDAOImpl;
import org.eclipse.emf.index.impl.memory.InverseReferenceCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectDAOImpl
extends BasicMemoryDAOImpl<EObjectDescriptor>
implements EObjectDescriptor.DAO {
    private static final long serialVersionUID = -3733063632994588281L;
    protected transient InverseReferenceCache<ResourceDescriptor, EObjectDescriptor> resourceScope;
    protected transient InverseReferenceCache<EClassDescriptor, EObjectDescriptor> eClassScope;

    @Override
    public void store(EObjectDescriptor element) {
        super.store(element);
        this.resourceScope.put(element);
        this.eClassScope.put(element);
    }

    @Override
    public void delete(EObjectDescriptor element) {
        super.delete(element);
        this.resourceScope.remove(element);
        this.eClassScope.remove(element);
    }

    @Override
    protected boolean doModify(EObjectDescriptor element, Object modification) {
        if (modification instanceof EObjectDescriptor) {
            this.eClassScope.remove(element);
            boolean isModified = ((EObjectDescriptorImpl)element).copyDetails((EObjectDescriptor)modification);
            this.eClassScope.put(element);
            return isModified;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void initialize(IndexStore indexStore) {
        super.initialize(indexStore);
        this.resourceScope = new InverseReferenceCache<ResourceDescriptor, EObjectDescriptor>(){

            @Override
            protected List<ResourceDescriptor> targets(EObjectDescriptor source) {
                return Collections.singletonList(source.getResourceDescriptor());
            }
        };
        this.eClassScope = new InverseReferenceCache<EClassDescriptor, EObjectDescriptor>(){

            @Override
            protected List<EClassDescriptor> targets(EObjectDescriptor source) {
                ArrayList<EClassDescriptor> classes = new ArrayList<EClassDescriptor>();
                classes.add(source.getEClassDescriptor());
                EClassDescriptor[] superClasses = source.getEClassDescriptor().getSuperClasses();
                if (superClasses != null) {
                    classes.addAll(Arrays.asList(superClasses));
                }
                return classes;
            }
        };
        for (EObjectDescriptor eObjectDescriptor : this.store) {
            this.resourceScope.put(eObjectDescriptor);
            this.eClassScope.put(eObjectDescriptor);
        }
    }

    @Override
    public EObjectDescriptor.Query createQuery() {
        return new EObjectQuery();
    }

    @Override
    public IGenericQuery<EObjectDescriptor> createQueryEObjectsByType(EClass eClass) {
        return DefaultQueryTool.createQueryEObjectsByType((EObjectDescriptor.DAO)this, eClass);
    }

    @Override
    public IGenericQuery<EObjectDescriptor> createQueryEObjectsByType(EClassDescriptor eClassDescriptor) {
        return this.eClassScope.createQuery(eClassDescriptor);
    }

    @Override
    public IGenericQuery<EObjectDescriptor> createQueryEObjectByURI(URI fragmentURI) {
        return DefaultQueryTool.createQueryEObjectByURI(this, fragmentURI);
    }

    public EObjectDescriptor.Query createQueryEObjectInResource(EObject eObject, ResourceDescriptor resourceDescriptor) {
        return DefaultQueryTool.createQueryEObjectsInResource(this, eObject, resourceDescriptor);
    }

    @Override
    public IGenericQuery<EObjectDescriptor> createQueryEObjectsInResource(ResourceDescriptor resourceDescriptor) {
        return this.resourceScope.createQuery(resourceDescriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EObjectQuery
    extends BasicMemoryDAOImpl.Query
    implements EObjectDescriptor.Query {
        private ResourceDescriptor resourceDescriptor;
        private ResourceDescriptor.Query resourceQuery;
        private String fragmentPattern;
        private String namePattern;
        private EClassDescriptor typeDescriptor;
        private EClassDescriptor.Query typeQuery;
        private Map<String, Serializable> userDataPatterns;

        protected EObjectQuery() {
        }

        @Override
        public EObjectQuery resource(ResourceDescriptor resourceDescriptor) {
            if (this.resourceQuery != null) {
                throw new IllegalArgumentException("ReourceQuery already configured");
            }
            this.resourceDescriptor = resourceDescriptor;
            return this;
        }

        @Override
        public ResourceDescriptor.Query resource() {
            if (this.resourceDescriptor != null) {
                throw new IllegalArgumentException("ReourceQuery already configured");
            }
            this.resourceQuery = EObjectDAOImpl.this.indexStore.resourceDAO().createQuery();
            return this.resourceQuery;
        }

        @Override
        public EObjectQuery fragment(String pattern) {
            this.fragmentPattern = pattern;
            return this;
        }

        @Override
        public EObjectQuery name(String pattern) {
            this.namePattern = pattern;
            return this;
        }

        @Override
        public EObjectQuery eClass(EClassDescriptor typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        @Override
        public EClassDescriptor.Query eClass() {
            this.typeQuery = EObjectDAOImpl.this.indexStore.eClassDAO().createQuery();
            return this.typeQuery;
        }

        @Override
        public EObjectQuery userData(String key, Serializable pattern) {
            if (this.userDataPatterns == null) {
                this.userDataPatterns = new HashMap<String, Serializable>();
            }
            this.userDataPatterns.put(key, pattern);
            return this;
        }

        public boolean matches(EObjectDescriptor elementDescriptor) {
            if (this.matchesGlobbing(elementDescriptor.getFragment(), this.fragmentPattern) && this.matchesGlobbing(elementDescriptor.getName(), this.namePattern)) {
                if (this.userDataPatterns != null) {
                    for (Map.Entry<String, Serializable> userDataEntry : this.userDataPatterns.entrySet()) {
                        if (this.matchesGlobbing(elementDescriptor.getUserData(userDataEntry.getKey()), userDataEntry.getValue())) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        protected Collection<EObjectDescriptor> scope() {
            Collection<EObjectDescriptor> eObjectsByEClass;
            Collection<EObjectDescriptor> eObjectsByResource = EObjectDAOImpl.this.resourceScope.lookup(this.resourceDescriptor, this.resourceQuery);
            Collection<EObjectDescriptor> mergedScopes = this.mergeScopes(eObjectsByResource, eObjectsByEClass = EObjectDAOImpl.this.eClassScope.lookup(this.typeDescriptor, this.typeQuery));
            return mergedScopes == null ? super.scope() : mergedScopes;
        }
    }
}

