/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.index.IGenericQuery;
import org.eclipse.emf.index.IndexStore;
import org.eclipse.emf.index.ecore.EClassDescriptor;
import org.eclipse.emf.index.ecore.EPackageDescriptor;
import org.eclipse.emf.index.impl.DefaultQueryTool;
import org.eclipse.emf.index.impl.memory.BasicMemoryDAOImpl;
import org.eclipse.emf.index.impl.memory.InverseReferenceCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EClassDAOImpl
extends BasicMemoryDAOImpl<EClassDescriptor>
implements EClassDescriptor.DAO {
    private static final long serialVersionUID = -1180283728678782547L;
    protected transient InverseReferenceCache<EPackageDescriptor, EClassDescriptor> ePackageScope;
    protected transient InverseReferenceCache<EClassDescriptor, EClassDescriptor> superClassScope;

    @Override
    public void store(EClassDescriptor element) {
        super.store(element);
        this.ePackageScope.put(element);
        this.superClassScope.put(element);
    }

    @Override
    public void delete(EClassDescriptor element) {
        super.delete(element);
        this.ePackageScope.remove(element);
        this.superClassScope.remove(element);
    }

    @Override
    protected boolean doModify(EClassDescriptor element, Object modification) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initialize(IndexStore indexStore) {
        super.initialize(indexStore);
        this.ePackageScope = new InverseReferenceCache<EPackageDescriptor, EClassDescriptor>(){

            @Override
            protected List<EPackageDescriptor> targets(EClassDescriptor source) {
                return Collections.singletonList(source.getEPackageDescriptor());
            }
        };
        this.superClassScope = new InverseReferenceCache<EClassDescriptor, EClassDescriptor>(){

            @Override
            protected List<EClassDescriptor> targets(EClassDescriptor source) {
                return source.getSuperClasses() != null ? Arrays.asList(source.getSuperClasses()) : new ArrayList(0);
            }
        };
        for (EClassDescriptor eClassDescriptor : this.store) {
            this.ePackageScope.put(eClassDescriptor);
            this.superClassScope.put(eClassDescriptor);
        }
    }

    @Override
    public EClassDescriptor.Query createQuery() {
        return new EClassQuery();
    }

    public EClassDescriptor.Query createQueryEClass(EClass eClass) {
        return DefaultQueryTool.createQueryEClass(this, eClass);
    }

    @Override
    public IGenericQuery<EClassDescriptor> createQueryEClassesInPackage(EPackageDescriptor ePackageDescriptor) {
        return this.ePackageScope.createQuery(ePackageDescriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EClassQuery
    extends BasicMemoryDAOImpl.Query
    implements EClassDescriptor.Query {
        private String namePattern;
        private EPackageDescriptor ePackageDescriptor;
        private EPackageDescriptor.Query ePackageQuery;
        private EClassDescriptor superClassDescriptor;
        private EClassDescriptor.Query superClassQuery;

        protected EClassQuery() {
        }

        @Override
        public EClassDescriptor.Query name(String pattern) {
            this.namePattern = pattern;
            return this;
        }

        @Override
        public EClassQuery ePackage(EPackageDescriptor ePackageDescriptor) {
            if (this.ePackageQuery != null) {
                throw new IllegalStateException("EPackageScope already configured");
            }
            this.ePackageDescriptor = ePackageDescriptor;
            return this;
        }

        @Override
        public EPackageDescriptor.Query ePackage() {
            if (this.ePackageDescriptor != null) {
                throw new IllegalStateException("EPackageScope already configured");
            }
            this.ePackageQuery = EClassDAOImpl.this.indexStore.ePackageDAO().createQuery();
            return this.ePackageQuery;
        }

        @Override
        public EClassDescriptor.Query superClass() {
            if (this.superClassDescriptor != null) {
                throw new IllegalStateException("ESuperClassScope already configured");
            }
            this.superClassQuery = EClassDAOImpl.this.indexStore.eClassDAO().createQuery();
            return this.superClassQuery;
        }

        @Override
        public EClassDescriptor.Query superClass(EClassDescriptor eClassDescriptor) {
            if (this.superClassQuery != null) {
                throw new IllegalStateException("ESuperClassScope already configured");
            }
            this.superClassDescriptor = eClassDescriptor;
            return this;
        }

        protected boolean matches(EClassDescriptor typeDescriptor) {
            return this.matchesGlobbing(typeDescriptor.getName(), this.namePattern);
        }

        protected Collection<EClassDescriptor> scope() {
            Collection<EClassDescriptor> eClassesBySuperClass;
            Collection<EClassDescriptor> eClassesByEPackage = EClassDAOImpl.this.ePackageScope.lookup(this.ePackageDescriptor, this.ePackageQuery);
            Collection<EClassDescriptor> mergedScopes = this.mergeScopes(eClassesByEPackage, eClassesBySuperClass = EClassDAOImpl.this.superClassScope.lookup(this.superClassDescriptor, this.superClassQuery));
            return mergedScopes == null ? super.scope() : mergedScopes;
        }
    }
}

