/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl.memory;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.index.IDAO;
import org.eclipse.emf.index.IGenericQuery;
import org.eclipse.emf.index.IndexStore;
import org.eclipse.emf.index.event.IndexChangeEvent;
import org.eclipse.emf.index.event.impl.IndexChangeEventImpl;
import org.eclipse.emf.index.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicMemoryDAOImpl<T>
implements IDAO<T>,
Serializable {
    private static final long serialVersionUID = -5346820953902280859L;
    protected Set<T> store = new HashSet<T>();
    protected transient IndexStore indexStore;

    protected BasicMemoryDAOImpl() {
    }

    @Override
    public void store(T element) {
        this.store.add(element);
        this.indexStore.fireIndexChangedEvent(new IndexChangeEventImpl(element, IndexChangeEvent.Type.ADDED));
    }

    @Override
    public void delete(T element) {
        this.store.remove(element);
        this.indexStore.fireIndexChangedEvent(new IndexChangeEventImpl(element, IndexChangeEvent.Type.REMOVED));
    }

    @Override
    public void modify(T element, Object modification) {
        if (this.doModify(element, modification)) {
            this.indexStore.fireIndexChangedEvent(new IndexChangeEventImpl(element, IndexChangeEvent.Type.MODIFIED));
        }
    }

    @Override
    public void initialize(IndexStore indexStore) {
        this.indexStore = indexStore;
    }

    protected abstract boolean doModify(T var1, Object var2);

    public void save(ObjectOutputStream out) throws IOException {
        out.writeInt(this.store.size());
        for (T descriptor : this.store) {
            out.writeObject(descriptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Query
    implements IGenericQuery<T> {
        protected Query() {
        }

        protected boolean matchesGlobbing(Serializable test, Serializable pattern) {
            if (test instanceof String && pattern instanceof String) {
                String testAsString = (String)((Object)test);
                String patternAsString = (String)((Object)pattern);
                this.matchesGlobbing(testAsString, patternAsString);
            }
            return test.equals(pattern);
        }

        protected boolean matchesGlobbing(String testString, String pattern) {
            if (pattern == null) {
                return true;
            }
            if (testString == null || "".equals(pattern)) {
                return false;
            }
            int patternLength = pattern.length();
            if (pattern.charAt(0) == '*') {
                if (patternLength > 1 && pattern.charAt(patternLength - 1) == '*') {
                    return testString.contains(pattern.substring(1, patternLength - 2));
                }
                return testString.endsWith(pattern.substring(1));
            }
            if (pattern.charAt(patternLength - 1) == '*') {
                return testString.startsWith(pattern.substring(0, patternLength - 1));
            }
            return testString.equals(pattern);
        }

        protected abstract boolean matches(T var1);

        protected Collection<T> scope() {
            return BasicMemoryDAOImpl.this.store;
        }

        @Override
        public T executeSingleResult() {
            try {
                BasicMemoryDAOImpl.this.indexStore.beginRead();
                Collection queryScope = this.scope();
                if (queryScope != null) {
                    for (Object candidate : queryScope) {
                        if (!this.matches(candidate)) continue;
                        Object t = candidate;
                        return t;
                    }
                }
                return null;
            }
            finally {
                BasicMemoryDAOImpl.this.indexStore.endRead();
            }
        }

        @Override
        public List<T> executeListResult() {
            try {
                BasicMemoryDAOImpl.this.indexStore.beginRead();
                ArrayList result = null;
                Collection queryScope = this.scope();
                if (queryScope != null) {
                    for (Object candidate : queryScope) {
                        if (!this.matches(candidate)) continue;
                        if (result == null) {
                            result = new ArrayList();
                        }
                        result.add(candidate);
                    }
                }
                List list = result == null ? Collections.emptyList() : result;
                return list;
            }
            finally {
                BasicMemoryDAOImpl.this.indexStore.endRead();
            }
        }

        protected Collection<T> mergeScopes(Collection<T> scope0, Collection<T> scope1) {
            if (scope0 == null) {
                return scope1;
            }
            if (scope1 == null) {
                return scope0;
            }
            if (CollectionUtils.isNotEmpty(scope0)) {
                if (CollectionUtils.isNotEmpty(scope1)) {
                    ArrayList mergedScope = new ArrayList(scope0);
                    mergedScope.retainAll(scope1);
                    return mergedScope;
                }
                return scope0;
            }
            return scope1;
        }
    }
}

