/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.index.ResourceDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDescriptorImpl
implements ResourceDescriptor,
Serializable {
    private static final long serialVersionUID = 4559062618979870492L;
    protected long indexingDate;
    protected String uri;
    protected Map<String, Serializable> userData;

    public ResourceDescriptorImpl(String uri, long indexingDate, Map<String, Serializable> userData) {
        this.uri = uri;
        this.indexingDate = indexingDate;
        if (userData != null) {
            this.userData = Collections.unmodifiableMap(userData);
        }
    }

    @Override
    public long getIndexingDate() {
        return this.indexingDate;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public Map<String, Serializable> getUserData() {
        return this.userData;
    }

    @Override
    public Serializable getUserData(String key) {
        return this.userData == null ? null : this.userData.get(key);
    }

    public String toString() {
        return this.uri;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceDescriptor) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)obj;
            return this.hashCode() == resourceDescriptor.hashCode() && this.uri.equals(resourceDescriptor.getURI());
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean copyDetails(ResourceDescriptor resourceDesc) {
        boolean hasChanged = false;
        Map<String, Serializable> newUserData = resourceDesc.getUserData();
        if (newUserData != null) {
            if (!newUserData.equals(this.userData)) {
                this.userData = Collections.unmodifiableMap(new HashMap<String, Serializable>(newUserData));
                hasChanged = true;
            }
        } else if (this.userData != null) {
            this.userData = null;
            hasChanged = true;
        }
        if (resourceDesc.getIndexingDate() != this.indexingDate) {
            this.indexingDate = resourceDesc.getIndexingDate();
        }
        return hasChanged;
    }
}

