/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl;

import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.eclipse.emf.index.EObjectDescriptor;
import org.eclipse.emf.index.EReferenceDescriptor;
import org.eclipse.emf.index.IPersistableIndexStore;
import org.eclipse.emf.index.ResourceDescriptor;
import org.eclipse.emf.index.ecore.EClassDescriptor;
import org.eclipse.emf.index.ecore.EPackageDescriptor;
import org.eclipse.emf.index.impl.BasicIndexStore;
import org.eclipse.emf.index.impl.memory.EClassDAOImpl;
import org.eclipse.emf.index.impl.memory.EObjectDAOImpl;
import org.eclipse.emf.index.impl.memory.EPackageDAOImpl;
import org.eclipse.emf.index.impl.memory.EReferenceDAOImpl;
import org.eclipse.emf.index.impl.memory.ResourceDAOImpl;

public class PersistableIndexStore
extends BasicIndexStore
implements IPersistableIndexStore {
    @Inject
    public PersistableIndexStore(EClassDescriptor.DAO eClassDao, ResourceDescriptor.DAO resourceDao, EObjectDescriptor.DAO eObjectDao, EReferenceDescriptor.DAO eReferenceDao, EPackageDescriptor.DAO ePackageDao) {
        super(eClassDao, resourceDao, eObjectDao, eReferenceDao, ePackageDao);
        if (!(this.ePackageDAO instanceof Serializable && this.eClassDAO instanceof Serializable && this.resourceDAO instanceof Serializable && this.eObjectDAO instanceof Serializable && this.eReferenceDAO instanceof Serializable)) {
            throw new IllegalStateException("All DAOs of a PersistableIndexStore must be persistable");
        }
    }

    public PersistableIndexStore() {
        super(new EClassDAOImpl(), new ResourceDAOImpl(), new EObjectDAOImpl(), new EReferenceDAOImpl(), new EPackageDAOImpl());
    }

    public void save(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(outputStream));
        try {
            objectOutputStream.writeObject(this.ePackageDAO);
            objectOutputStream.writeObject(this.eClassDAO);
            objectOutputStream.writeObject(this.resourceDAO);
            objectOutputStream.writeObject(this.eObjectDAO);
            objectOutputStream.writeObject(this.eReferenceDAO);
        }
        finally {
            objectOutputStream.close();
        }
    }

    public void load(InputStream inputStream) throws IOException, ClassNotFoundException, ClassCastException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
        try {
            this.ePackageDAO = (EPackageDescriptor.DAO)objectInputStream.readObject();
            this.eClassDAO = (EClassDescriptor.DAO)objectInputStream.readObject();
            this.resourceDAO = (ResourceDescriptor.DAO)objectInputStream.readObject();
            this.eObjectDAO = (EObjectDescriptor.DAO)objectInputStream.readObject();
            this.eReferenceDAO = (EReferenceDescriptor.DAO)objectInputStream.readObject();
        }
        finally {
            objectInputStream.close();
        }
        this.initializeDAOs();
    }
}

