/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl;

import java.io.Serializable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.index.EReferenceDescriptor;
import org.eclipse.emf.index.ResourceDescriptor;

public class EReferenceDescriptorImpl
implements EReferenceDescriptor,
Serializable {
    private static final long serialVersionUID = -9111865497767470045L;
    private ResourceDescriptor sourceResourceDescriptor;
    private String sourceFragment;
    private String referenceName;
    private int index;
    private ResourceDescriptor targetResourceDescriptor;
    private String targetFragment;

    public EReferenceDescriptorImpl(ResourceDescriptor sourceResourceDescriptor, String sourceFragment, String referenceName, ResourceDescriptor targetResourceDescriptor, String targetFragment) {
        this(sourceResourceDescriptor, sourceFragment, referenceName, -1, targetResourceDescriptor, targetFragment);
    }

    public EReferenceDescriptorImpl(ResourceDescriptor sourceResourceDescriptor, String sourceFragment, String referenceName, int index, ResourceDescriptor targetResourceDescriptor, String targetFragment) {
        this.sourceResourceDescriptor = sourceResourceDescriptor;
        this.sourceFragment = sourceFragment;
        this.referenceName = referenceName;
        this.targetResourceDescriptor = targetResourceDescriptor;
        this.targetFragment = targetFragment;
        this.index = index;
    }

    public ResourceDescriptor getSourceResourceDescriptor() {
        return this.sourceResourceDescriptor;
    }

    public String getSourceFragment() {
        return this.sourceFragment;
    }

    public ResourceDescriptor getTargetResourceDescriptor() {
        return this.targetResourceDescriptor;
    }

    public String getTargetFragment() {
        return this.targetFragment;
    }

    public URI getSourceURI() {
        return URI.createURI((String)(String.valueOf(this.sourceResourceDescriptor.getURI()) + "#" + this.sourceFragment));
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public URI getTargetURI() {
        return URI.createURI((String)(String.valueOf(this.targetResourceDescriptor.getURI()) + "#" + this.targetFragment));
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        b.append(this.sourceResourceDescriptor.getURI());
        b.append("#");
        b.append(this.sourceFragment);
        b.append(" --");
        b.append(this.referenceName);
        b.append("--> ");
        b.append(this.targetResourceDescriptor.getURI());
        b.append("#");
        b.append(this.targetFragment);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EReferenceDescriptor) {
            EReferenceDescriptor eReferenceDescriptor = (EReferenceDescriptor)obj;
            return eReferenceDescriptor.hashCode() == this.hashCode() && this.sourceFragment.equals(eReferenceDescriptor.getSourceFragment()) && this.targetFragment.equals(eReferenceDescriptor.getTargetFragment()) && this.sourceResourceDescriptor.equals(eReferenceDescriptor.getSourceResourceDescriptor()) && this.targetResourceDescriptor.equals(eReferenceDescriptor.getTargetResourceDescriptor()) && this.referenceName.equals(eReferenceDescriptor.getReferenceName()) && this.index == eReferenceDescriptor.getIndex();
        }
        return false;
    }

    public int hashCode() {
        return this.referenceName.hashCode() + 7 * this.sourceFragment.hashCode() + 31 * this.targetFragment.hashCode() + 53 * this.sourceResourceDescriptor.hashCode() + 89 * this.targetResourceDescriptor.hashCode();
    }
}

