/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.index.EObjectDescriptor;
import org.eclipse.emf.index.ResourceDescriptor;
import org.eclipse.emf.index.ecore.EClassDescriptor;
import org.eclipse.emf.index.impl.BasicEObjectDescriptorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectDescriptorImpl
extends BasicEObjectDescriptorImpl {
    private static final long serialVersionUID = -8283957734898241601L;
    private Map<String, Serializable> userData;

    public EObjectDescriptorImpl(ResourceDescriptor resourceDescriptor, String fragment, String name, String displayName, EClassDescriptor typeDescriptor, Map<String, Serializable> userData) {
        super(resourceDescriptor, fragment, name, displayName, typeDescriptor);
        if (userData != null) {
            this.userData = Collections.unmodifiableMap(userData);
        }
    }

    @Override
    public boolean copyDetails(EObjectDescriptor newDesc) {
        boolean hasChanged = super.copyDetails(newDesc);
        Map<String, Serializable> newUserData = newDesc.getUserData();
        if (newUserData != null) {
            if (!newUserData.equals(this.userData)) {
                this.userData = Collections.unmodifiableMap(new HashMap<String, Serializable>(newUserData));
                return true;
            }
        } else if (this.userData != null) {
            this.userData = null;
            return true;
        }
        return hasChanged;
    }

    @Override
    public Serializable getUserData(String key) {
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    @Override
    public Map<String, Serializable> getUserData() {
        return this.userData;
    }

    public String toString() {
        return this.displayName;
    }
}

