/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.index.EObjectDescriptor;
import org.eclipse.emf.index.EReferenceDescriptor;
import org.eclipse.emf.index.IGenericQuery;
import org.eclipse.emf.index.ResourceDescriptor;
import org.eclipse.emf.index.ecore.EClassDescriptor;
import org.eclipse.emf.index.ecore.EPackageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQueryTool {
    public static EObjectDescriptor.Query createQueryEObjectsInResource(EObjectDescriptor.DAO dao, EObject eObject, ResourceDescriptor resourceDescriptor) {
        URI resourceURI;
        Resource resource = eObject.eResource();
        if (resource != null && (resourceURI = resource.getURI()) != null) {
            String fragment = resource.getURIFragment(eObject);
            return dao.createQuery().resource(resourceDescriptor).fragment(fragment);
        }
        return null;
    }

    public static EClassDescriptor.Query createQueryEClass(EClassDescriptor.DAO dao, EClass eClass) {
        String nsURI;
        EPackage ePackage;
        String name = eClass.getName();
        if (name != null && (ePackage = eClass.getEPackage()) != null && (nsURI = ePackage.getNsURI()) != null) {
            EClassDescriptor.Query eClassQuery = dao.createQuery().name(name);
            eClassQuery.name(name).ePackage().nsURI(nsURI);
            return eClassQuery;
        }
        return null;
    }

    public static EReferenceDescriptor.Query createQueryEReferencesTo(EReferenceDescriptor.DAO dao, EObject target) {
        String targetFragment;
        Resource resource = target.eResource();
        if (resource != null && (targetFragment = resource.getURIFragment(target)) != null) {
            EReferenceDescriptor.Query eReferenceQuery = dao.createQuery().targetFragment(targetFragment);
            eReferenceQuery.targetResource().uri(resource.getURI().toString());
            return eReferenceQuery;
        }
        return null;
    }

    public static ResourceDescriptor.Query createQueryResource(ResourceDescriptor.DAO dao, Resource resource) {
        if (resource != null && resource.getURI() != null) {
            return dao.createQuery().uri(resource.getURI().toString());
        }
        return null;
    }

    public static EObjectDescriptor.Query createQueryEObjectsInResource(EObjectDescriptor.DAO dao, ResourceDescriptor resourceDescriptor) {
        return dao.createQuery().resource(resourceDescriptor);
    }

    public static IGenericQuery<EClassDescriptor> createQueryEClassesInPackage(EClassDescriptor.DAO dao, EPackageDescriptor ePackageDescriptor) {
        return dao.createQuery().ePackage(ePackageDescriptor);
    }

    public static IGenericQuery<EReferenceDescriptor> createQueryEReferencesFrom(EReferenceDescriptor.DAO dao, URI sourceURI) {
        EReferenceDescriptor.Query query = dao.createQuery().sourceFragment(sourceURI.fragment());
        query.sourceResource().uri(sourceURI.trimFragment().toString());
        return query;
    }

    public static IGenericQuery<EReferenceDescriptor> createQueryEReferencesTo(EReferenceDescriptor.DAO dao, URI targetURI) {
        EReferenceDescriptor.Query query = dao.createQuery().targetFragment(targetURI.fragment());
        query.targetResource().uri(targetURI.trimFragment().toString());
        return query;
    }

    public static IGenericQuery<EPackageDescriptor> createQueryEPackage(EPackageDescriptor.DAO dao, EPackage ePackage) {
        return dao.createQuery().nsURI(ePackage.getNsURI());
    }

    public static IGenericQuery<EObjectDescriptor> createQueryEObjectsByType(EObjectDescriptor.DAO dao, EClass eClass) {
        EObjectDescriptor.Query eObjectQuery = dao.createQuery();
        eObjectQuery.eClass().name(eClass.getName()).ePackage().nsURI(eClass.getEPackage().getNsURI());
        return eObjectQuery;
    }

    public static IGenericQuery<EObjectDescriptor> createQueryEObjectByURI(EObjectDescriptor.DAO dao, URI fragmentUri) {
        EObjectDescriptor.Query eObjectQuery = dao.createQuery();
        eObjectQuery.fragment(fragmentUri.fragment()).resource().uri(fragmentUri.trimFragment().toString());
        return eObjectQuery;
    }

    public static IGenericQuery<EObjectDescriptor> createQueryEObjectsByType(EObjectDescriptor.DAO dao, EClassDescriptor eClassDescriptor) {
        return dao.createQuery().eClass(eClassDescriptor);
    }
}

