/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emf.index.EObjectDescriptor;
import org.eclipse.emf.index.EReferenceDescriptor;
import org.eclipse.emf.index.IndexStore;
import org.eclipse.emf.index.ResourceDescriptor;
import org.eclipse.emf.index.ecore.EClassDescriptor;
import org.eclipse.emf.index.ecore.EPackageDescriptor;
import org.eclipse.emf.index.event.IndexChangeEvent;
import org.eclipse.emf.index.event.IndexChangeListener;

public abstract class BasicIndexStore
implements IndexStore {
    protected EClassDescriptor.DAO eClassDAO;
    protected ResourceDescriptor.DAO resourceDAO;
    protected EObjectDescriptor.DAO eObjectDAO;
    protected EReferenceDescriptor.DAO eReferenceDAO;
    protected EPackageDescriptor.DAO ePackageDAO;
    private List<IndexChangeEvent> firedEvents = new ArrayList<IndexChangeEvent>();
    private boolean isInTransaction = false;
    protected ReadWriteLock readWriteLock;
    private List<IndexChangeListener> indexChangeListeners = new ArrayList<IndexChangeListener>();

    @Inject
    public BasicIndexStore(EClassDescriptor.DAO eClassDao, ResourceDescriptor.DAO resourceDao, EObjectDescriptor.DAO eObjectDao, EReferenceDescriptor.DAO eReferenceDao, EPackageDescriptor.DAO ePackageDao) {
        this.readWriteLock = new ReentrantReadWriteLock();
        this.eClassDAO = eClassDao;
        this.resourceDAO = resourceDao;
        this.eObjectDAO = eObjectDao;
        this.eReferenceDAO = eReferenceDao;
        this.ePackageDAO = ePackageDao;
        this.initializeDAOs();
    }

    public EClassDescriptor.DAO eClassDAO() {
        return this.eClassDAO;
    }

    public ResourceDescriptor.DAO resourceDAO() {
        return this.resourceDAO;
    }

    public EObjectDescriptor.DAO eObjectDAO() {
        return this.eObjectDAO;
    }

    public EReferenceDescriptor.DAO eReferenceDAO() {
        return this.eReferenceDAO;
    }

    public EPackageDescriptor.DAO ePackageDAO() {
        return this.ePackageDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexChangeListener(IndexChangeListener listener) {
        List<IndexChangeListener> list = this.indexChangeListeners;
        synchronized (list) {
            this.indexChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexChangeListener(IndexChangeListener listener) {
        List<IndexChangeListener> list = this.indexChangeListeners;
        synchronized (list) {
            this.indexChangeListeners.remove(listener);
        }
    }

    public void beginWrite() {
        this.readWriteLock.writeLock().lock();
        if (this.isInTransaction) {
            throw new IllegalStateException("Transaction already open");
        }
        this.isInTransaction = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endWrite() {
        if (!this.isInTransaction) {
            throw new IllegalStateException("Transaction not open");
        }
        List<IndexChangeListener> list = this.indexChangeListeners;
        synchronized (list) {
            for (IndexChangeEvent event : this.firedEvents) {
                this.fireEventNow(event);
            }
            this.firedEvents.clear();
        }
        this.isInTransaction = false;
        this.readWriteLock.writeLock().unlock();
    }

    public void beginRead() {
        this.readWriteLock.readLock().lock();
    }

    public void endRead() {
        this.readWriteLock.readLock().unlock();
    }

    private void fireEventNow(IndexChangeEvent event) {
        for (IndexChangeListener indexChangeListener : this.indexChangeListeners) {
            indexChangeListener.indexChanged(event);
        }
    }

    public void fireIndexChangedEvent(IndexChangeEvent event) {
        if (this.isInTransaction) {
            this.firedEvents.add(event);
        } else {
            this.fireEventNow(event);
        }
    }

    protected void initializeDAOs() {
        this.ePackageDAO.initialize(this);
        this.eClassDAO.initialize(this);
        this.resourceDAO.initialize(this);
        this.eObjectDAO.initialize(this);
        this.eReferenceDAO.initialize(this);
    }
}

