/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.impl;

import java.io.Serializable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.index.EObjectDescriptor;
import org.eclipse.emf.index.ResourceDescriptor;
import org.eclipse.emf.index.ecore.EClassDescriptor;
import org.eclipse.emf.index.util.CollectionUtils;

public abstract class BasicEObjectDescriptorImpl
implements EObjectDescriptor,
Serializable {
    private static final long serialVersionUID = 5006367856591582998L;
    private transient URI cachedFragmentURI;
    protected String name;
    protected String displayName;
    protected String fragment;
    protected ResourceDescriptor resourceDescriptor;
    protected EClassDescriptor typeDescriptor;

    protected BasicEObjectDescriptorImpl(ResourceDescriptor resourceDescriptor, String fragment, String name, String displayName, EClassDescriptor typeDescriptor) {
        this.resourceDescriptor = resourceDescriptor;
        this.fragment = fragment;
        this.name = name;
        this.displayName = displayName;
        this.typeDescriptor = typeDescriptor;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    public String getFragment() {
        return this.fragment;
    }

    public URI getFragmentURI() {
        if (this.cachedFragmentURI == null) {
            this.cachedFragmentURI = URI.createURI((String)this.resourceDescriptor.getURI()).appendFragment(this.getFragment());
        }
        return this.cachedFragmentURI;
    }

    public EClassDescriptor getEClassDescriptor() {
        return this.typeDescriptor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EObjectDescriptor) {
            EObjectDescriptor elementDescriptor = (EObjectDescriptor)obj;
            return obj.hashCode() == this.hashCode() && this.fragment.equals(elementDescriptor.getFragment()) && this.resourceDescriptor.equals(elementDescriptor.getResourceDescriptor());
        }
        return false;
    }

    public int hashCode() {
        return this.fragment.hashCode() + 97 * this.resourceDescriptor.hashCode();
    }

    public boolean copyDetails(EObjectDescriptor eObjectDesc) {
        boolean hasChanged = false;
        if (!CollectionUtils.equalsNullSafe(this.name, eObjectDesc.getName())) {
            this.name = eObjectDesc.getName();
            hasChanged = true;
        }
        if (!CollectionUtils.equalsNullSafe(this.displayName, eObjectDesc.getDisplayName())) {
            this.displayName = eObjectDesc.getDisplayName();
            hasChanged = true;
        }
        if (!CollectionUtils.equalsNullSafe(this.getEClassDescriptor(), eObjectDesc.getEClassDescriptor())) {
            this.typeDescriptor = eObjectDesc.getEClassDescriptor();
            hasChanged = true;
        }
        return hasChanged;
    }
}

