/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.index.ecore.impl;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.index.IndexStore;
import org.eclipse.emf.index.ecore.EClassDescriptor;
import org.eclipse.emf.index.ecore.EPackageDescriptor;
import org.eclipse.emf.index.ecore.EcoreIndexFeeder;
import org.eclipse.emf.index.ecore.impl.EClassDescriptorImpl;
import org.eclipse.emf.index.ecore.impl.EPackageDescriptorImpl;
import org.eclipse.emf.index.internal.LogFacade;
import org.eclipse.emf.index.util.CollectionUtils;
import org.eclipse.emf.index.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreIndexFeederImpl
implements EcoreIndexFeeder {
    private IndexStore index;

    @Inject
    public EcoreIndexFeederImpl(IndexStore index) {
        this.index = index;
    }

    @Override
    public List<EClassDescriptor> index(EPackage ePackage, boolean isRecurseSubpackages) {
        EPackageDescriptor ePackageDescriptor = this.internalIndexEPackage(ePackage);
        List<EClassDescriptor> typeDescriptors = this.internalIndexEPackageContents(ePackage, ePackageDescriptor);
        if (isRecurseSubpackages) {
            for (EPackage subPackage : ePackage.getESubpackages()) {
                if (ePackage.eResource() != null && subPackage.eResource() != ePackage.eResource()) continue;
                typeDescriptors.addAll(this.index(subPackage, isRecurseSubpackages));
            }
        }
        return typeDescriptors;
    }

    @Override
    public void feedEPackagesFromRegistry() {
        ArrayList<String> processedNsURIs = new ArrayList<String>();
        boolean hasChanged = true;
        while (hasChanged) {
            ArrayList nsURIs = new ArrayList(EPackage.Registry.INSTANCE.keySet());
            hasChanged = false;
            for (String nsURI : nsURIs) {
                try {
                    if (processedNsURIs.contains(nsURI)) continue;
                    hasChanged = true;
                    processedNsURIs.add(nsURI);
                    EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                    this.index(ePackage, true);
                }
                catch (Exception exc) {
                    LogFacade.logError("Error indexin EPackages from registry", exc);
                }
            }
        }
    }

    protected EPackageDescriptor internalIndexEPackage(EPackage ePackage) {
        EPackageDescriptor ePackageDescriptor = this.index.ePackageDAO().createQueryEPackage(ePackage).executeSingleResult();
        if (ePackageDescriptor == null) {
            ePackageDescriptor = new EPackageDescriptorImpl(ePackage, System.currentTimeMillis());
            this.index.ePackageDAO().store(ePackageDescriptor);
        }
        return ePackageDescriptor;
    }

    protected List<EClassDescriptor> internalIndexEPackageContents(EPackage ePackage, EPackageDescriptor ePackageDescriptor) {
        List<EClassDescriptor> oldEClassDescriptors = CollectionUtils.toList(this.index.eClassDAO().createQueryEClassesInPackage(ePackageDescriptor).executeListResult());
        ArrayList<EClassDescriptor> newEClassDescriptors = new ArrayList<EClassDescriptor>();
        MultiMap<EClassDescriptor, EClass> forwardSuperClassMap = new MultiMap<EClassDescriptor, EClass>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            newEClassDescriptors.add(this.internalIndexEClass((EClass)eClassifier, ePackageDescriptor, oldEClassDescriptors, forwardSuperClassMap));
        }
        for (Map.Entry danglingSuperClassEntry : forwardSuperClassMap.entrySet()) {
            boolean isSuperClassesAdded = false;
            ArrayList<EClassDescriptor> superClassDescriptors = new ArrayList<EClassDescriptor>();
            EClassDescriptor subClassDescriptor = (EClassDescriptor)danglingSuperClassEntry.getKey();
            EClassDescriptor[] existingSuperClasses = subClassDescriptor.getSuperClasses();
            if (existingSuperClasses != null) {
                superClassDescriptors.addAll(Arrays.asList(existingSuperClasses));
            }
            for (EClass danglingSuperClass : (Set)danglingSuperClassEntry.getValue()) {
                EClassDescriptor superClassDescriptor = this.internalIndexSingleEClass(danglingSuperClass);
                if (superClassDescriptor != null) {
                    isSuperClassesAdded = true;
                    superClassDescriptors.add(superClassDescriptor);
                    continue;
                }
                LogFacade.logError("Cannot index superclass " + danglingSuperClass.getName());
            }
            if (!isSuperClassesAdded) continue;
            this.index.eClassDAO().delete(subClassDescriptor);
            subClassDescriptor = new EClassDescriptorImpl(subClassDescriptor.getName(), ePackageDescriptor, superClassDescriptors.toArray(new EClassDescriptor[superClassDescriptors.size()]));
            this.index.eClassDAO().store(subClassDescriptor);
        }
        if (oldEClassDescriptors != null) {
            for (EClassDescriptor staleClassDescriptor : oldEClassDescriptors) {
                this.index.eClassDAO().delete(staleClassDescriptor);
            }
        }
        return newEClassDescriptors;
    }

    protected EClassDescriptor internalIndexEClass(EClass eClass, EPackageDescriptor ePackageDescriptor, Collection<EClassDescriptor> oldEClassDescriptors, MultiMap<EClassDescriptor, EClass> forwardSuperClassMap) {
        ArrayList<EClassDescriptor> indexedSuperClasses = null;
        HashSet<EClass> forwardSuperClasses = null;
        for (EClass superType : eClass.getEAllSuperTypes()) {
            EClassDescriptor superClassDescriptor = this.index.eClassDAO().createQueryEClass(superType).executeSingleResult();
            if (superClassDescriptor == null) {
                if (forwardSuperClasses == null) {
                    forwardSuperClasses = new HashSet<EClass>();
                }
                forwardSuperClasses.add(superType);
                continue;
            }
            if (indexedSuperClasses == null) {
                indexedSuperClasses = new ArrayList<EClassDescriptor>();
            }
            indexedSuperClasses.add(superClassDescriptor);
        }
        EClassDescriptor[] superClassDescriptors = indexedSuperClasses == null ? null : indexedSuperClasses.toArray(new EClassDescriptor[indexedSuperClasses.size()]);
        EClassDescriptorImpl typeDescriptor = new EClassDescriptorImpl(eClass, ePackageDescriptor, superClassDescriptors);
        if (oldEClassDescriptors == null || !oldEClassDescriptors.remove(typeDescriptor)) {
            this.index.eClassDAO().store(typeDescriptor);
        }
        if (forwardSuperClasses != null) {
            forwardSuperClassMap.put(typeDescriptor, (EClass)forwardSuperClasses);
        }
        return typeDescriptor;
    }

    protected EClassDescriptor internalIndexSingleEClass(EClass eClass) {
        EClassDescriptor existingEClassDescriptor = this.index.eClassDAO().createQueryEClass(eClass).executeSingleResult();
        if (existingEClassDescriptor != null) {
            return existingEClassDescriptor;
        }
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == null) {
            LogFacade.logError("EClass " + eClass.getName() + " does not have a package");
            return null;
        }
        EPackageDescriptor ePackageDescriptor = this.internalIndexEPackage(ePackage);
        EClassDescriptorImpl typeDescriptor = new EClassDescriptorImpl(eClass, ePackageDescriptor, null);
        this.index.eClassDAO().store(typeDescriptor);
        return typeDescriptor;
    }
}

