/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.featureinstance;

import de.uka.ipd.sdq.dialogs.error.ErrorDisplayDialog;
import de.uka.ipd.sdq.featureconfig.ConfigNode;
import de.uka.ipd.sdq.featureconfig.ConfigState;
import de.uka.ipd.sdq.featureconfig.Configuration;
import de.uka.ipd.sdq.featureconfig.FeatureConfig;
import de.uka.ipd.sdq.featureconfig.impl.featureconfigFactoryImpl;
import de.uka.ipd.sdq.featureinstance.FeatureConfigFunctionality;
import de.uka.ipd.sdq.featureinstance.InstanceValidateAction;
import de.uka.ipd.sdq.featureinstance.TreeContentProvider;
import de.uka.ipd.sdq.featureinstance.TreeLabelProvider;
import de.uka.ipd.sdq.featuremodel.Feature;
import de.uka.ipd.sdq.featuremodel.FeatureDiagram;
import de.uka.ipd.sdq.featuremodel.FeatureGroup;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class FeatureConfigWidget {
    private Composite parent;
    private String sourceInput;
    private String targetInput;
    protected AdapterFactoryEditingDomain editingDomain;
    protected CheckboxTreeViewer treeViewer;
    protected PropertySheetPage propertySheetPage;
    protected ICheckStateListener listener;
    protected Resource resource;
    protected FeatureDiagram featureDiagram;
    protected Object root;
    protected TreeViewer contentOutlineViewer;
    protected IContentOutlinePage contentOutlinePage;
    protected boolean dirtyFlag = false;
    protected FeatureConfig defaultConfig;
    protected FeatureConfig overridesConfig;
    private List<ICheckStateListener> checkStateListeners;
    private String errorMessage;
    private InstanceValidateAction validateAction;
    private FeatureConfigFunctionality functions;

    public FeatureConfigWidget(Composite parent) {
        this.parent = parent;
        this.checkStateListeners = new LinkedList<ICheckStateListener>();
        this.validateAction = new InstanceValidateAction();
        this.functions = new FeatureConfigFunctionality();
        this.editingDomain = this.functions.initializeEditingDomain();
    }

    public void setSourceInput(String sourceInput) {
        this.sourceInput = sourceInput;
    }

    public void setTargetInput(String targetInput) {
        this.targetInput = targetInput;
    }

    public void validate() {
        this.validateAction.setConfiguration(this.functions.getConfiguration(this.resource));
        this.validateAction.setShell(this.parent.getShell());
        this.validateAction.run();
    }

    public boolean createPages() {
        boolean valid = this.checkValid();
        if (valid) {
            this.createResource();
            if (this.resource == null) {
                this.errorMessage = "Resource couldn't be loaded";
                return false;
            }
            return this.createEditor();
        }
        return false;
    }

    protected boolean createEditor() {
        boolean valid = this.handleConfigCases();
        if (this.featureDiagram != null && this.overridesConfig != null && valid) {
            this.createViewer(this.featureDiagram);
            return valid;
        }
        this.errorMessage = "FeatureDiagram couldn't be referenced";
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleConfigCases() {
        URI newResourceURI;
        FeatureConfig featureConfig;
        EList configList;
        Configuration configuration = this.functions.getConfiguration(this.resource);
        EList tempOverrides = configuration.getConfigOverrides();
        FeatureConfig tempDefault = configuration.getDefaultConfig();
        if ((tempOverrides == null || tempOverrides.isEmpty()) && tempDefault == null) {
            this.errorMessage = "Model contains no FeatureConfig object";
            return false;
        }
        if (tempOverrides == null && tempDefault != null) {
            EList configList2 = tempDefault.getConfignode();
            if (!configList2.isEmpty()) {
                this.featureDiagram = this.functions.navigateToFeatureDiagram(((ConfigNode)configList2.iterator().next()).getOrigin(), this.editingDomain);
                URI newResourceURI2 = URI.createPlatformResourceURI((String)this.targetInput, (boolean)true);
                this.createNewConfigResource(newResourceURI2, this.featureDiagram, tempDefault);
                return true;
            }
            this.errorMessage = "FeatureConfig objects are empty";
            return false;
        }
        if (tempOverrides != null && !tempOverrides.isEmpty() && tempDefault == null) {
            FeatureConfig featureConfig2 = (FeatureConfig)tempOverrides.get(0);
            EList configList3 = featureConfig2.getConfignode();
            if (!configList3.isEmpty()) {
                this.featureDiagram = this.functions.navigateToFeatureDiagram(((ConfigNode)configList3.iterator().next()).getOrigin(), this.editingDomain);
                this.overridesConfig = featureConfig2;
                URI newResourceURI3 = URI.createPlatformResourceURI((String)this.targetInput, (boolean)true);
                this.doSaveAs(newResourceURI3);
                return true;
            }
            this.errorMessage = "FeatureConfig objects are empty";
            return false;
        }
        boolean configPresent = false;
        if (!tempOverrides.isEmpty() && !(configList = (featureConfig = (FeatureConfig)tempOverrides.get(0)).getConfignode()).isEmpty()) {
            this.featureDiagram = this.functions.navigateToFeatureDiagram(((ConfigNode)configList.iterator().next()).getOrigin(), this.editingDomain);
            this.overridesConfig = featureConfig;
            configPresent = true;
        }
        if (!(configList = tempDefault.getConfignode()).isEmpty()) {
            if (configPresent) {
                this.defaultConfig = tempDefault;
                newResourceURI = URI.createPlatformResourceURI((String)this.targetInput, (boolean)true);
                this.doSaveAs(newResourceURI);
                return true;
            }
            this.featureDiagram = this.functions.navigateToFeatureDiagram(((ConfigNode)configList.iterator().next()).getOrigin(), this.editingDomain);
            newResourceURI = URI.createPlatformResourceURI((String)this.targetInput, (boolean)true);
            this.createNewConfigResource(newResourceURI, this.featureDiagram, tempDefault);
            return true;
        }
        if (configPresent) {
            newResourceURI = URI.createPlatformResourceURI((String)this.targetInput, (boolean)true);
            this.doSaveAs(newResourceURI);
            return true;
        }
        this.errorMessage = "FeatureConfig objects are empty";
        return false;
    }

    public void createViewer(FeatureDiagram root) {
        Feature curRoot;
        if (this.treeViewer == null) {
            this.treeViewer = new CheckboxTreeViewer(this.parent);
            this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
            for (ICheckStateListener currentListener : this.checkStateListeners) {
                this.treeViewer.addCheckStateListener(currentListener);
            }
        }
        this.treeViewer.setInput((Object)root);
        this.treeViewer.expandAll();
        if (root != null) {
            this.treeViewer.setGrayed((Object)root.getRootFeature(), true);
            curRoot = root.getRootFeature();
            this.functions.grayFeatureGroups(curRoot.getChildrelation(), this.treeViewer);
        }
        if (this.defaultConfig != null) {
            this.functions.markDefaultConfig(this.defaultConfig, this.treeViewer);
        }
        if (this.overridesConfig != null) {
            this.functions.markOverridesConfig(this.overridesConfig, this.treeViewer);
        }
        this.listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof FeatureGroup) {
                    FeatureConfigWidget.this.treeViewer.setChecked(event.getElement(), !event.getChecked());
                } else {
                    Object parent = FeatureConfigWidget.this.editingDomain.getParent(event.getElement());
                    if (event.getElement() instanceof Feature) {
                        if (FeatureConfigWidget.this.functions.checkMandatory((Feature)event.getElement(), FeatureConfigWidget.this.editingDomain)) {
                            FeatureConfigWidget.this.treeViewer.setChecked(event.getElement(), true);
                            FeatureConfigWidget.this.functions.uncheckInModel((Feature)event.getElement(), true, FeatureConfigWidget.this.overridesConfig);
                        } else if (parent != null && !(parent instanceof FeatureDiagram)) {
                            if (FeatureConfigWidget.this.treeViewer.getGrayed(event.getElement())) {
                                FeatureConfigWidget.this.treeViewer.setGrayed(event.getElement(), false);
                            }
                            if (event.getChecked()) {
                                FeatureConfigWidget.this.functions.uncheckInModel((Feature)event.getElement(), true, FeatureConfigWidget.this.overridesConfig);
                                FeatureConfigWidget.this.functions.checkParents(event.getElement(), FeatureConfigWidget.this.treeViewer, FeatureConfigWidget.this.overridesConfig, FeatureConfigWidget.this.editingDomain);
                            } else {
                                FeatureConfigWidget.this.functions.uncheckInModel((Feature)event.getElement(), false, FeatureConfigWidget.this.overridesConfig);
                                FeatureConfigWidget.this.functions.uncheckParents(event.getElement(), FeatureConfigWidget.this.treeViewer, FeatureConfigWidget.this.overridesConfig, FeatureConfigWidget.this.editingDomain);
                            }
                        } else {
                            FeatureConfigWidget.this.treeViewer.setChecked(event.getElement(), !event.getChecked());
                        }
                        FeatureConfigWidget.this.dirtyFlag = true;
                    }
                }
            }
        };
        this.treeViewer.addCheckStateListener(this.listener);
        if (root != null) {
            curRoot = root.getRootFeature();
            this.functions.selectMandatoryFeatures(curRoot.getChildrelation(), this.treeViewer, this.overridesConfig);
        }
    }

    protected void createResource() {
        URI resourceURI = URI.createPlatformResourceURI((String)this.sourceInput, (boolean)true);
        this.resource = null;
        try {
            this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception exception) {
            this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
    }

    protected void createNewConfigResource(URI newResourceURI, FeatureDiagram featureDiagram, FeatureConfig defaultRef) {
        if (newResourceURI == null) {
            throw new NullPointerException("No Config file stored in resource!");
        }
        this.resource = this.resource.getResourceSet().createResource(newResourceURI);
        featureconfigFactoryImpl factory = new featureconfigFactoryImpl();
        Configuration newConfig = factory.createConfiguration();
        newConfig.setName(String.valueOf(featureDiagram.getName()) + "_config");
        FeatureConfig newOverrides = factory.createFeatureConfig();
        newConfig.getConfigOverrides().add((Object)newOverrides);
        if (defaultRef == null) {
            defaultRef = factory.createFeatureConfig();
        }
        newConfig.setDefaultConfig(defaultRef);
        ConfigNode rootConfigNode = factory.createConfigNode();
        rootConfigNode.setConfigState(ConfigState.ELIMINATED);
        rootConfigNode.setOrigin(featureDiagram.getRootFeature());
        newOverrides.getConfignode().add((Object)rootConfigNode);
        this.resource.getContents().add((Object)newConfig);
        this.defaultConfig = defaultRef;
        this.overridesConfig = newOverrides;
        try {
            this.resource.load(Collections.EMPTY_MAP);
            this.resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException iOException) {
            ErrorDisplayDialog errord = new ErrorDisplayDialog(this.parent.getShell(), new Throwable("Could not load or save the Resource!"));
            errord.open();
        }
    }

    private boolean checkValid() {
        if (this.sourceInput == null || this.targetInput == null || !this.sourceInput.endsWith(".featureconfig") || !this.targetInput.endsWith(".featureconfig")) {
            this.errorMessage = "Empty Source/Target file or wrong file ending";
            return false;
        }
        return true;
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : FeatureConfigWidget.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !FeatureConfigWidget.this.functions.isPersisted(resource, FeatureConfigWidget.this.editingDomain) || FeatureConfigWidget.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        resource.save(saveOptions);
                    }
                    catch (IOException iOException) {
                        ErrorDisplayDialog errord = new ErrorDisplayDialog(FeatureConfigWidget.this.parent.getShell(), new Throwable("Resource couldn't be loaded or saved!"));
                        errord.open();
                    }
                    first = false;
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.parent.getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.dirtyFlag = false;
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorDisplayDialog errord = new ErrorDisplayDialog(this.parent.getShell(), new Throwable("Resource couldn't be saved!"));
            errord.open();
        }
        catch (InterruptedException interruptedException) {
            ErrorDisplayDialog errord = new ErrorDisplayDialog(this.parent.getShell(), new Throwable("Resource couldn't be saved!"));
            errord.open();
        }
    }

    protected void doSaveAs(URI uri) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.checkStateListeners.add(iCheckStateListener);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

