/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelSynchronizeWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ccvs.ui.wizards.SharingWizardPageActionGroup;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPageSaveablePart;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class SharingWizardSyncPage
extends CVSWizardPage
implements IDiffChangeListener {
    private static final String PAGE_HEIGHT = "SyncPageHeight";
    private static final String PAGE_WIDTH = "SyncPageWidth";
    private ParticipantPageSaveablePart input;
    private ISynchronizePageConfiguration configuration;
    private IProject project;
    PageBook pageBook;
    private Control syncPage;
    private Control noChangesPage;
    private int width;
    private int height;
    private SharingWizardPageActionGroup sharingWizardPageActionGroup;
    private Button fCheckbox;

    public SharingWizardSyncPage(String pageName, String title, ImageDescriptor titleImage, String description) {
        super(pageName, title, titleImage, description);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void createControl(Composite parent) {
        PixelConverter converter = SWTUtils.createDialogPixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)-1));
        this.setControl((Control)composite);
        this.pageBook = new PageBook(composite, 0);
        this.pageBook.setLayoutData((Object)SWTUtils.createHVFillGridData());
        this.syncPage = this.createSyncPage(this.pageBook);
        this.noChangesPage = this.createNoChangesPage(this.pageBook);
        this.noChangesPage.setLayoutData((Object)SWTUtils.createHVFillGridData());
        this.updatePage();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.sharing_sync_page_context");
        Dialog.applyDialogFont((Control)parent);
    }

    private IResourceDiffTree getDiffTree() {
        if (this.configuration == null) {
            return null;
        }
        return this.getParticipant().getContext().getDiffTree();
    }

    private Control createSyncPage(PageBook pageBook) {
        Composite composite = this.createComposite((Composite)pageBook, 1, false);
        this.input = this.createCompareInput();
        this.input.createPartControl(composite);
        this.getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
        this.fCheckbox = new Button(composite, 32);
        this.fCheckbox.setLayoutData((Object)SWTUtils.createHFillGridData());
        this.fCheckbox.setText(CVSUIMessages.SharingWizardSyncPage_12);
        this.fCheckbox.setSelection(true);
        return composite;
    }

    private Control createNoChangesPage(PageBook pageBook) {
        Composite composite = this.createComposite((Composite)pageBook, 1, false);
        this.createWrappingLabel(composite, NLS.bind((String)CVSUIMessages.SharingWizardSyncPage_3, (Object[])new String[]{this.project.getName()}), 0);
        return composite;
    }

    void showErrors(final IStatus[] status) {
        if (status.length == 0) {
            return;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = CVSUIMessages.SharingWizardSyncPage_8;
                if (status.length == 1) {
                    IStatus s = status[0];
                    if (s.getException() instanceof CoreException) {
                        s = ((CoreException)s.getException()).getStatus();
                    }
                    ErrorDialog.openError((Shell)SharingWizardSyncPage.this.getShell(), (String)title, null, (IStatus)s);
                } else {
                    MultiStatus multi = new MultiStatus("org.eclipse.team.cvs.ui", 0, status, CVSUIMessages.SharingWizardSyncPage_9, null);
                    ErrorDialog.openError((Shell)SharingWizardSyncPage.this.getShell(), (String)title, null, (IStatus)multi);
                }
            }
        });
    }

    private ParticipantPageSaveablePart createCompareInput() {
        ISynchronizeParticipant participant = this.createParticipant();
        this.configuration = participant.createPageConfiguration();
        this.configuration.setProperty("org.eclipse.team.ui.P_TOOLBAR_MENU", (Object)new String[]{"navigate", "cvs_sharing_page_actions"});
        this.sharingWizardPageActionGroup = new SharingWizardPageActionGroup();
        this.configuration.addActionContribution((SynchronizePageActionGroup)this.sharingWizardPageActionGroup);
        this.configuration.setRunnableContext((IRunnableContext)this.getContainer());
        CompareConfiguration cc = new CompareConfiguration();
        cc.setLeftEditable(false);
        cc.setRightEditable(false);
        ParticipantPageSaveablePart part = new ParticipantPageSaveablePart(this.getShell(), cc, this.configuration, participant);
        part.setShowContentPanes(false);
        return part;
    }

    private ISynchronizeParticipant createParticipant() {
        return ModelSynchronizeWizard.createWorkspaceParticipant(Utils.getResourceMappings((Object[])new IProject[]{this.project}), this.getShell());
    }

    public void dispose() {
        if (this.input != null) {
            this.input.getParticipant().dispose();
            this.input.dispose();
        }
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(null);
    }

    private void updatePage() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (SharingWizardSyncPage.this.pageBook.isDisposed()) {
                    return;
                }
                if (SharingWizardSyncPage.this.getDiffTree().isEmpty()) {
                    SharingWizardSyncPage.this.pageBook.showPage(SharingWizardSyncPage.this.noChangesPage);
                } else {
                    SharingWizardSyncPage.this.pageBook.showPage(SharingWizardSyncPage.this.syncPage);
                }
            }
        });
    }

    public ModelSynchronizeParticipant getParticipant() {
        return (ModelSynchronizeParticipant)this.configuration.getParticipant();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.syncPage.isVisible()) {
            Viewer viewer;
            this.initializeSize();
            this.getShell().setSize(Math.max(this.width, 300), Math.max(this.height, 300));
            if (this.input != null && (viewer = this.input.getPageConfiguration().getPage().getViewer()) instanceof AbstractTreeViewer && !viewer.getControl().isDisposed()) {
                ((AbstractTreeViewer)viewer).expandToLevel(2);
            }
        }
    }

    private void initializeSize() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            try {
                this.width = settings.getInt(PAGE_WIDTH);
                this.height = settings.getInt(PAGE_HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.width == 0) {
            this.width = 640;
        }
        if (this.height == 0) {
            this.height = 480;
        }
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            Point size = this.getShell().getSize();
            settings.put(PAGE_WIDTH, size.x);
            settings.put(PAGE_HEIGHT, size.y);
        }
    }

    public boolean commitChanges() {
        return this.fCheckbox != null ? this.fCheckbox.getSelection() && this.hasOutgoingChanges() : false;
    }

    private boolean hasOutgoingChanges() {
        IResourceDiffTree tree = this.getDiffTree();
        return tree != null && tree.hasMatchingDiffs(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff diff) {
                if (diff instanceof IThreeWayDiff) {
                    IThreeWayDiff twd = (IThreeWayDiff)diff;
                    return twd.getDirection() == 256 || twd.getDirection() == 768;
                }
                return false;
            }
        });
    }

    public IProject getProject() {
        return this.project;
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        this.showErrors(event.getErrors());
        this.updatePage();
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }
}

